/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNormalizerRegistry
extends DefaultSchemaObjectRegistry<Normalizer>
implements NormalizerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNormalizerRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public DefaultNormalizerRegistry() {
        super(SchemaObjectType.NORMALIZER, new OidRegistry());
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        if (schemaName == null) {
            return;
        }
        for (Normalizer normalizer : this) {
            if (!schemaName.equalsIgnoreCase(normalizer.getSchemaName())) continue;
            String oid = normalizer.getOid();
            String removed = this.unregister(oid);
            if (!DEBUG) continue;
            LOG.debug("Removed {} with oid {} from the registry", (Object)removed, (Object)oid);
        }
    }

    @Override
    public DefaultNormalizerRegistry copy() {
        DefaultNormalizerRegistry copy = new DefaultNormalizerRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.schemaObjectType).append(": ");
        boolean isFirst = true;
        for (String name : this.byName.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            Normalizer normalizer = (Normalizer)this.byName.get(name);
            String fqcn = normalizer.getFqcn();
            int lastDotPos = fqcn.lastIndexOf(46);
            sb.append('<').append(normalizer.getOid()).append(", ");
            if (lastDotPos > 0) {
                sb.append(fqcn.substring(lastDotPos + 1));
            } else {
                sb.append(fqcn);
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

