/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.authn.ppolicy;

import org.apache.directory.shared.ldap.model.exception.LdapException;

public class PasswordPolicyException
extends LdapException {
    private static final long serialVersionUID = -9158126177779964262L;
    private int errorCode;
    private static final int[] VALID_CODES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    public PasswordPolicyException(Throwable cause) {
        super(cause);
    }

    public PasswordPolicyException(String message) {
        super(message);
    }

    public PasswordPolicyException(String message, int errorCode) {
        super(message);
        this.validateErrorCode(errorCode);
        this.errorCode = errorCode;
    }

    public PasswordPolicyException(int errorCode) {
        this.validateErrorCode(errorCode);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private void validateErrorCode(int errorCode) {
        for (int i : VALID_CODES) {
            if (i != errorCode) continue;
            return;
        }
        throw new IllegalArgumentException("Unknown password policy response error code " + errorCode);
    }
}

