/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.i18n.I18n;

public abstract class AbstractAsn1Object
implements Asn1Object {
    private int currentLength;
    private int expectedLength;
    private AbstractAsn1Object parent;
    private int tlvId;

    protected AbstractAsn1Object(int tlvId) {
        this.tlvId = tlvId;
    }

    protected AbstractAsn1Object() {
        this.tlvId = -1;
    }

    public void addLength(int length) throws DecoderException {
        this.currentLength += length;
        if (this.currentLength > this.expectedLength) {
            throw new DecoderException(I18n.err(I18n.ERR_00041_CURRENT_LENGTH_EXCEED_EXPECTED_LENGTH, new Object[0]));
        }
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void setCurrentLength(int currentLength) {
        this.currentLength = currentLength;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    public AbstractAsn1Object getParent() {
        return this.parent;
    }

    public void setParent(AbstractAsn1Object parent) {
        this.parent = parent;
    }

    public int getTlvId() {
        return this.tlvId;
    }
}

