/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephoneNumberComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(TelephoneNumberComparator.class);

    public TelephoneNumberComparator(String oid) {
        super(oid);
    }

    private String strip(String telephoneNumber) {
        char[] telephoneNumberArray = telephoneNumber.toCharArray();
        int pos = 0;
        for (char c : telephoneNumberArray) {
            if (c == ' ' || c == '-') continue;
            telephoneNumberArray[pos++] = c;
        }
        return new String(telephoneNumberArray, 0, pos);
    }

    @Override
    public int compare(String telephoneNumber1, String telephoneNumber2) {
        LOG.debug("comparing TelephoneNumber objects '{}' with '{}'", (Object)telephoneNumber1, (Object)telephoneNumber2);
        if (telephoneNumber1 == null) {
            return telephoneNumber2 == null ? 0 : -1;
        }
        if (telephoneNumber2 == null) {
            return 1;
        }
        String strippedTelephoneNumber1 = this.strip(telephoneNumber1);
        String strippedTelephoneNumber2 = this.strip(telephoneNumber2);
        return strippedTelephoneNumber1.compareToIgnoreCase(strippedTelephoneNumber2);
    }
}

