/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.sp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureRequestImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaStoredProcUtils {
    private JavaStoredProcUtils() {
    }

    public static byte[] getClassFileAsStream(Class<?> clazz) throws NamingException {
        File file;
        InputStream in;
        String fullClassName = clazz.getName();
        int lastDot = fullClassName.lastIndexOf(46);
        String classFileName = fullClassName.substring(lastDot + 1) + ".class";
        URL url = clazz.getResource(classFileName);
        try {
            in = url.openStream();
        }
        catch (IOException ioe) {
            NamingException ne = new NamingException();
            ne.setRootCause(ioe);
            throw ne;
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException urie) {
            NamingException ne = new NamingException();
            ne.setRootCause(urie);
            throw ne;
        }
        int size = (int)file.length();
        byte[] buf = new byte[size];
        try {
            in.read(buf);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return buf;
    }

    public static void loadStoredProcedureClass(LdapContext ctx, Class<?> clazz) throws NamingException {
        byte[] buf = JavaStoredProcUtils.getClassFileAsStream(clazz);
        String fullClassName = clazz.getName();
        BasicAttributes attributes = new BasicAttributes("objectClass", "top", true);
        attributes.get("objectClass").add("storedProcUnit");
        attributes.get("objectClass").add("javaStoredProcUnit");
        attributes.put("storedProcLangId", "Java");
        attributes.put("storedProcUnitName", fullClassName);
        attributes.put("javaByteCode", buf);
        ctx.createSubcontext("storedProcUnitName=" + fullClassName, (Attributes)attributes);
    }

    public static Object callStoredProcedure(LdapContext ctx, String procedureName, Object[] arguments) throws NamingException {
        Object responseObject;
        String language = "Java";
        try {
            StoredProcedureRequestImpl req = new StoredProcedureRequestImpl(0, procedureName, language);
            for (int i = 0; i < arguments.length; ++i) {
                byte[] type = arguments[i].getClass().getName().getBytes("UTF-8");
                byte[] value = SerializationUtils.serialize((Serializable)arguments[i]);
                req.addParameter(type, value);
            }
            ExtendedRequest jndiReq = LdapApiServiceFactory.getSingleton().toJndi(req);
            ExtendedResponse resp = ctx.extendedOperation(jndiReq);
            byte[] responseStream = resp.getEncodedValue();
            responseObject = SerializationUtils.deserialize(responseStream);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return responseObject;
    }
}

