/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.protocol.codec.KerberosDecoder;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.directory.shared.kerberos.components.Checksum;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncTicketPart;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddress;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.KdcReq;
import org.apache.directory.shared.kerberos.components.KdcReqBody;
import org.apache.directory.shared.kerberos.components.LastReq;
import org.apache.directory.shared.kerberos.components.PaData;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.InvalidTicketException;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.flags.TicketFlag;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.directory.shared.kerberos.messages.EncTgsRepPart;
import org.apache.directory.shared.kerberos.messages.TgsRep;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketGrantingService {
    private static final Logger LOG = LoggerFactory.getLogger(TicketGrantingService.class);
    private static final CipherTextHandler cipherTextHandler = new CipherTextHandler();
    private static final String SERVICE_NAME = "Ticket-Granting Service (TGS)";
    private static final ChecksumHandler checksumHandler = new ChecksumHandler();

    public static void execute(TicketGrantingContext tgsContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            TicketGrantingService.monitorRequest(tgsContext);
        }
        TicketGrantingService.configureTicketGranting(tgsContext);
        TicketGrantingService.selectEncryptionType(tgsContext);
        TicketGrantingService.getAuthHeader(tgsContext);
        TicketGrantingService.verifyTgt(tgsContext);
        TicketGrantingService.getTicketPrincipalEntry(tgsContext);
        TicketGrantingService.verifyTgtAuthHeader(tgsContext);
        TicketGrantingService.verifyBodyChecksum(tgsContext);
        TicketGrantingService.getRequestPrincipalEntry(tgsContext);
        TicketGrantingService.generateTicket(tgsContext);
        TicketGrantingService.buildReply(tgsContext);
    }

    private static void configureTicketGranting(TicketGrantingContext tgsContext) throws KerberosException {
        tgsContext.setCipherTextHandler(cipherTextHandler);
        if (tgsContext.getRequest().getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KDC_ERR_BAD_PVNO);
        }
    }

    private static void monitorRequest(KdcContext kdcContext) throws Exception {
        KdcReq request = kdcContext.getRequest();
        try {
            String clientAddress = kdcContext.getClientAddress().getHostAddress();
            StringBuffer sb = new StringBuffer();
            sb.append("Received Ticket-Granting Service (TGS) request:");
            sb.append("\n\tmessageType:           " + (Object)((Object)request.getMessageType()));
            sb.append("\n\tprotocolVersionNumber: " + request.getProtocolVersionNumber());
            sb.append("\n\tclientAddress:         " + clientAddress);
            sb.append("\n\tnonce:                 " + request.getKdcReqBody().getNonce());
            sb.append("\n\tkdcOptions:            " + request.getKdcReqBody().getKdcOptions());
            sb.append("\n\tclientPrincipal:       " + request.getKdcReqBody().getCName());
            sb.append("\n\tserverPrincipal:       " + request.getKdcReqBody().getSName());
            sb.append("\n\tencryptionType:        " + KerberosUtils.getEncryptionTypesString(request.getKdcReqBody().getEType()));
            sb.append("\n\trealm:                 " + request.getKdcReqBody().getRealm());
            sb.append("\n\tfrom time:             " + request.getKdcReqBody().getFrom());
            sb.append("\n\ttill time:             " + request.getKdcReqBody().getTill());
            sb.append("\n\trenew-till time:       " + request.getKdcReqBody().getRTime());
            sb.append("\n\thostAddresses:         " + request.getKdcReqBody().getAddresses());
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_153, new Object[0]), e);
        }
    }

    private static void selectEncryptionType(TicketGrantingContext tgsContext) throws Exception {
        TicketGrantingContext kdcContext = tgsContext;
        KdcServer config = kdcContext.getConfig();
        List<EncryptionType> requestedTypes = kdcContext.getRequest().getKdcReqBody().getEType();
        EncryptionType bestType = KerberosUtils.getBestEncryptionType(requestedTypes, config.getEncryptionTypes());
        LOG.debug("Session will use encryption type {}.", (Object)bestType);
        if (bestType == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
        }
        kdcContext.setEncryptionType(bestType);
    }

    private static void getAuthHeader(TicketGrantingContext tgsContext) throws Exception {
        KdcReq request = tgsContext.getRequest();
        if (request.getPaData() == null || request.getPaData().size() < 1) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        byte[] undecodedAuthHeader = null;
        for (PaData paData : request.getPaData()) {
            if (paData.getPaDataType() != PaDataType.PA_TGS_REQ) continue;
            undecodedAuthHeader = paData.getPaDataValue();
        }
        if (undecodedAuthHeader == null) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        ApReq authHeader = KerberosDecoder.decodeApReq(undecodedAuthHeader);
        Ticket tgt = authHeader.getTicket();
        tgsContext.setAuthHeader(authHeader);
        tgsContext.setTgt(tgt);
    }

    public static void verifyTgt(TicketGrantingContext tgsContext) throws KerberosException {
        KdcServer config = tgsContext.getConfig();
        Ticket tgt = tgsContext.getTgt();
        if (!tgt.getRealm().equals(config.getPrimaryRealm())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
        String tgtServerName = KerberosUtils.getKerberosPrincipal(tgt.getSName(), tgt.getRealm()).getName();
        String requestServerName = KerberosUtils.getKerberosPrincipal(tgsContext.getRequest().getKdcReqBody().getSName(), tgsContext.getRequest().getKdcReqBody().getRealm()).getName();
        if (!tgtServerName.equals(config.getServicePrincipal().getName()) && !tgtServerName.equals(requestServerName)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
    }

    private static void getTicketPrincipalEntry(TicketGrantingContext tgsContext) throws KerberosException {
        PrincipalName principal = tgsContext.getTgt().getSName();
        PrincipalStore store = tgsContext.getStore();
        KerberosPrincipal principalWithRealm = KerberosUtils.getKerberosPrincipal(principal, tgsContext.getTgt().getRealm());
        PrincipalStoreEntry entry = TicketGrantingService.getEntry(principalWithRealm, store, ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN);
        tgsContext.setTicketPrincipalEntry(entry);
    }

    private static void verifyTgtAuthHeader(TicketGrantingContext tgsContext) throws KerberosException {
        ApReq authHeader = tgsContext.getAuthHeader();
        Ticket tgt = tgsContext.getTgt();
        boolean isValidate = tgsContext.getRequest().getKdcReqBody().getKdcOptions().get(31);
        EncryptionType encryptionType = tgt.getEncPart().getEType();
        EncryptionKey serverKey = tgsContext.getTicketPrincipalEntry().getKeyMap().get((Object)encryptionType);
        long clockSkew = tgsContext.getConfig().getAllowableClockSkew();
        ReplayCache replayCache = tgsContext.getConfig().getReplayCache();
        boolean emptyAddressesAllowed = tgsContext.getConfig().isEmptyAddressesAllowed();
        InetAddress clientAddress = tgsContext.getClientAddress();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        Authenticator authenticator = TicketGrantingService.verifyAuthHeader(authHeader, tgt, serverKey, clockSkew, replayCache, emptyAddressesAllowed, clientAddress, cipherTextHandler, KeyUsage.TGS_REQ_PA_TGS_REQ_PADATA_AP_REQ_TGS_SESS_KEY, isValidate);
        tgsContext.setAuthenticator(authenticator);
    }

    private static void verifyBodyChecksum(TicketGrantingContext tgsContext) throws KerberosException {
        KdcServer config = tgsContext.getConfig();
        if (config.isBodyChecksumVerified()) {
            KdcReqBody body = tgsContext.getRequest().getKdcReqBody();
            ByteBuffer buf = ByteBuffer.allocate(body.computeLength());
            try {
                body.encode(buf);
            }
            catch (EncoderException e) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
            }
            byte[] bodyBytes = buf.array();
            Checksum authenticatorChecksum = tgsContext.getAuthenticator().getCksum();
            Ticket tgt = tgsContext.getTgt();
            EncTicketPart encTicketPart = tgt.getEncTicketPart();
            EncryptionKey sessionKey = encTicketPart.getKey();
            if (authenticatorChecksum == null || authenticatorChecksum.getChecksumType() == null || authenticatorChecksum.getChecksumValue() == null || bodyBytes == null) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
            }
            LOG.debug("Verifying body checksum type '{}'.", (Object)authenticatorChecksum.getChecksumType());
            checksumHandler.verifyChecksum(authenticatorChecksum, bodyBytes, sessionKey.getKeyValue(), KeyUsage.TGS_REQ_PA_TGS_REQ_PADATA_AP_REQ_AUTHNT_CKSUM_TGS_SESS_KEY);
        }
    }

    public static void getRequestPrincipalEntry(TicketGrantingContext tgsContext) throws KerberosException {
        KerberosPrincipal principal = KerberosUtils.getKerberosPrincipal(tgsContext.getRequest().getKdcReqBody().getSName(), tgsContext.getRequest().getKdcReqBody().getRealm());
        PrincipalStore store = tgsContext.getStore();
        PrincipalStoreEntry entry = TicketGrantingService.getEntry(principal, store, ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN);
        tgsContext.setRequestPrincipalEntry(entry);
    }

    private static void generateTicket(TicketGrantingContext tgsContext) throws KerberosException, InvalidTicketException {
        KdcReq request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Authenticator authenticator = tgsContext.getAuthenticator();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        KerberosPrincipal ticketPrincipal = KerberosUtils.getKerberosPrincipal(request.getKdcReqBody().getSName(), request.getKdcReqBody().getRealm());
        EncryptionType encryptionType = tgsContext.getEncryptionType();
        EncryptionKey serverKey = tgsContext.getRequestPrincipalEntry().getKeyMap().get((Object)encryptionType);
        KdcServer config = tgsContext.getConfig();
        EncTicketPart newTicketPart = new EncTicketPart();
        newTicketPart.setClientAddresses(tgt.getEncTicketPart().getClientAddresses());
        TicketGrantingService.processFlags(config, request, tgt, newTicketPart);
        EncryptionKey sessionKey = RandomKeyFactory.getRandomKey(tgsContext.getEncryptionType());
        newTicketPart.setKey(sessionKey);
        newTicketPart.setCName(tgt.getEncTicketPart().getCName());
        newTicketPart.setCRealm(tgt.getEncTicketPart().getCRealm());
        if (request.getKdcReqBody().getEncAuthorizationData() != null) {
            byte[] authorizationData = cipherTextHandler.decrypt(authenticator.getSubKey(), request.getKdcReqBody().getEncAuthorizationData(), KeyUsage.TGS_REQ_KDC_REQ_BODY_AUTHZ_DATA_ENC_WITH_TGS_SESS_KEY);
            AuthorizationData authData = KerberosDecoder.decodeAuthorizationData(authorizationData);
            authData.addEntry(tgt.getEncTicketPart().getAuthorizationData().getCurrentAD());
            newTicketPart.setAuthorizationData(authData);
        }
        TicketGrantingService.processTransited(newTicketPart, tgt);
        TicketGrantingService.processTimes(config, request, newTicketPart, tgt);
        if (request.getKdcReqBody().getKdcOptions().get(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        EncryptedData encryptedData = cipherTextHandler.seal(serverKey, newTicketPart, KeyUsage.AS_OR_TGS_REP_TICKET_WITH_SRVKEY);
        Ticket newTicket = new Ticket(request.getKdcReqBody().getSName(), encryptedData);
        newTicket.setEncTicketPart(newTicketPart);
        newTicket.setRealm(request.getKdcReqBody().getRealm());
        tgsContext.setNewTicket(newTicket);
    }

    private static void buildReply(TicketGrantingContext tgsContext) throws KerberosException {
        KdcReq request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Ticket newTicket = tgsContext.getNewTicket();
        TgsRep reply = new TgsRep();
        reply.setCName(tgt.getEncTicketPart().getCName());
        reply.setCRealm(tgt.getEncTicketPart().getCRealm());
        reply.setTicket(newTicket);
        EncKdcRepPart encKdcRepPart = new EncKdcRepPart();
        encKdcRepPart.setKey(newTicket.getEncTicketPart().getKey());
        encKdcRepPart.setNonce(request.getKdcReqBody().getNonce());
        encKdcRepPart.setLastReq(new LastReq());
        encKdcRepPart.setFlags(newTicket.getEncTicketPart().getFlags());
        encKdcRepPart.setClientAddresses(newTicket.getEncTicketPart().getClientAddresses());
        encKdcRepPart.setAuthTime(newTicket.getEncTicketPart().getAuthTime());
        encKdcRepPart.setStartTime(newTicket.getEncTicketPart().getStartTime());
        encKdcRepPart.setEndTime(newTicket.getEncTicketPart().getEndTime());
        encKdcRepPart.setSName(newTicket.getSName());
        encKdcRepPart.setSRealm(newTicket.getRealm());
        if (newTicket.getEncTicketPart().getFlags().isRenewable()) {
            encKdcRepPart.setRenewTill(newTicket.getEncTicketPart().getRenewTill());
        }
        if (LOG.isDebugEnabled()) {
            TicketGrantingService.monitorContext(tgsContext);
            TicketGrantingService.monitorReply(reply, encKdcRepPart);
        }
        EncTgsRepPart encTgsRepPart = new EncTgsRepPart();
        encTgsRepPart.setEncKdcRepPart(encKdcRepPart);
        Authenticator authenticator = tgsContext.getAuthenticator();
        EncryptedData encryptedData = authenticator.getSubKey() != null ? cipherTextHandler.seal(authenticator.getSubKey(), encTgsRepPart, KeyUsage.TGS_REP_ENC_PART_TGS_AUTHNT_SUB_KEY) : cipherTextHandler.seal(tgt.getEncTicketPart().getKey(), encTgsRepPart, KeyUsage.TGS_REP_ENC_PART_TGS_SESS_KEY);
        reply.setEncPart(encryptedData);
        reply.setEncKdcRepPart(encKdcRepPart);
        tgsContext.setReply(reply);
    }

    private static void monitorContext(TicketGrantingContext tgsContext) {
        try {
            Ticket tgt = tgsContext.getTgt();
            long clockSkew = tgsContext.getConfig().getAllowableClockSkew();
            ChecksumType checksumType = tgsContext.getAuthenticator().getCksum().getChecksumType();
            InetAddress clientAddress = tgsContext.getClientAddress();
            HostAddresses clientAddresses = tgt.getEncTicketPart().getClientAddresses();
            boolean caddrContainsSender = false;
            if (tgt.getEncTicketPart().getClientAddresses() != null) {
                caddrContainsSender = tgt.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Monitoring Ticket-Granting Service (TGS) context:");
            sb.append("\n\tclockSkew              " + clockSkew);
            sb.append("\n\tchecksumType           " + checksumType);
            sb.append("\n\tclientAddress          " + clientAddress);
            sb.append("\n\tclientAddresses        " + clientAddresses);
            sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
            PrincipalName requestServerPrincipal = tgsContext.getRequest().getKdcReqBody().getSName();
            PrincipalStoreEntry requestPrincipal = tgsContext.getRequestPrincipalEntry();
            sb.append("\n\tprincipal              " + requestServerPrincipal);
            sb.append("\n\tcn                     " + requestPrincipal.getCommonName());
            sb.append("\n\trealm                  " + requestPrincipal.getRealmName());
            sb.append("\n\tprincipal              " + requestPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + (Object)((Object)requestPrincipal.getSamType()));
            PrincipalName ticketServerPrincipal = tgsContext.getTgt().getSName();
            PrincipalStoreEntry ticketPrincipal = tgsContext.getTicketPrincipalEntry();
            sb.append("\n\tprincipal              " + ticketServerPrincipal);
            sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
            sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
            sb.append("\n\tprincipal              " + ticketPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + (Object)((Object)ticketPrincipal.getSamType()));
            EncryptionType encryptionType = tgsContext.getTgt().getEncPart().getEType();
            int keyVersion = ticketPrincipal.getKeyMap().get((Object)encryptionType).getKeyVersion();
            sb.append("\n\tTicket key type        " + (Object)((Object)encryptionType));
            sb.append("\n\tService key version    " + keyVersion);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_154, new Object[0]), e);
        }
    }

    private static void monitorReply(TgsRep success, EncKdcRepPart part) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("Responding with Ticket-Granting Service (TGS) reply:");
            sb.append("\n\tmessageType:           " + (Object)((Object)success.getMessageType()));
            sb.append("\n\tprotocolVersionNumber: " + success.getProtocolVersionNumber());
            sb.append("\n\tnonce:                 " + part.getNonce());
            sb.append("\n\tclientPrincipal:       " + success.getCName());
            sb.append("\n\tclient realm:          " + success.getCRealm());
            sb.append("\n\tserverPrincipal:       " + part.getSName());
            sb.append("\n\tserver realm:          " + part.getSRealm());
            sb.append("\n\tauth time:             " + part.getAuthTime());
            sb.append("\n\tstart time:            " + part.getStartTime());
            sb.append("\n\tend time:              " + part.getEndTime());
            sb.append("\n\trenew-till time:       " + part.getRenewTill());
            sb.append("\n\thostAddresses:         " + part.getClientAddresses());
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_155, new Object[0]), e);
        }
    }

    private static void processFlags(KdcServer config, KdcReq request, Ticket tgt, EncTicketPart newTicketPart) throws KerberosException {
        if (tgt.getEncTicketPart().getFlags().isPreAuth()) {
            newTicketPart.setFlag(TicketFlag.PRE_AUTHENT);
        }
        if (request.getKdcReqBody().getKdcOptions().get(1)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isForwardable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketPart.setFlag(TicketFlag.FORWARDABLE);
        }
        if (request.getKdcReqBody().getKdcOptions().get(2)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isForwardable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getKdcReqBody().getAddresses() != null && request.getKdcReqBody().getAddresses().getAddresses() != null && request.getKdcReqBody().getAddresses().getAddresses().length > 0) {
                newTicketPart.setClientAddresses(request.getKdcReqBody().getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketPart.setFlag(TicketFlag.FORWARDED);
        }
        if (tgt.getEncTicketPart().getFlags().isForwarded()) {
            newTicketPart.setFlag(TicketFlag.FORWARDED);
        }
        if (request.getKdcReqBody().getKdcOptions().get(3)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isProxiable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketPart.setFlag(TicketFlag.PROXIABLE);
        }
        if (request.getKdcReqBody().getKdcOptions().get(4)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isProxiable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getKdcReqBody().getAddresses() != null && request.getKdcReqBody().getAddresses().getAddresses() != null && request.getKdcReqBody().getAddresses().getAddresses().length > 0) {
                newTicketPart.setClientAddresses(request.getKdcReqBody().getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketPart.setFlag(TicketFlag.PROXY);
        }
        if (request.getKdcReqBody().getKdcOptions().get(5)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isMayPosdate()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketPart.setFlag(TicketFlag.MAY_POSTDATE);
        }
        if (request.getKdcReqBody().getKdcOptions().get(6)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isMayPosdate()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketPart.setFlag(TicketFlag.POSTDATED);
            newTicketPart.setFlag(TicketFlag.INVALID);
            newTicketPart.setStartTime(request.getKdcReqBody().getFrom());
        }
        if (request.getKdcReqBody().getKdcOptions().get(31)) {
            KerberosTime startTime;
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isInvalid()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            KerberosTime kerberosTime = startTime = tgt.getEncTicketPart().getStartTime() != null ? tgt.getEncTicketPart().getStartTime() : tgt.getEncTicketPart().getAuthTime();
            if (startTime.greaterThan(new KerberosTime())) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
            }
            TicketGrantingService.echoTicket(newTicketPart, tgt);
            newTicketPart.getFlags().clearFlag(TicketFlag.INVALID);
        }
        if (request.getKdcReqBody().getKdcOptions().get(0) || request.getKdcReqBody().getKdcOptions().get(7) || request.getKdcReqBody().getKdcOptions().get(9) || request.getKdcReqBody().getKdcOptions().get(10) || request.getKdcReqBody().getKdcOptions().get(11) || request.getKdcReqBody().getKdcOptions().get(12) || request.getKdcReqBody().getKdcOptions().get(13) || request.getKdcReqBody().getKdcOptions().get(14) || request.getKdcReqBody().getKdcOptions().get(15) || request.getKdcReqBody().getKdcOptions().get(16) || request.getKdcReqBody().getKdcOptions().get(17) || request.getKdcReqBody().getKdcOptions().get(18) || request.getKdcReqBody().getKdcOptions().get(19) || request.getKdcReqBody().getKdcOptions().get(20) || request.getKdcReqBody().getKdcOptions().get(21) || request.getKdcReqBody().getKdcOptions().get(22) || request.getKdcReqBody().getKdcOptions().get(23) || request.getKdcReqBody().getKdcOptions().get(24) || request.getKdcReqBody().getKdcOptions().get(25) || request.getKdcReqBody().getKdcOptions().get(29)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
    }

    private static void processTimes(KdcServer config, KdcReq request, EncTicketPart newTicketPart, Ticket tgt) throws KerberosException {
        KerberosTime now = new KerberosTime();
        newTicketPart.setAuthTime(tgt.getEncTicketPart().getAuthTime());
        KerberosTime startTime = request.getKdcReqBody().getFrom();
        if (startTime == null || startTime.lessThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) && !request.getKdcReqBody().getKdcOptions().get(6)) {
            startTime = now;
        }
        if (!(startTime == null || !startTime.greaterThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) || request.getKdcReqBody().getKdcOptions().get(6) && tgt.getEncTicketPart().getFlags().isMayPosdate())) {
            throw new KerberosException(ErrorType.KDC_ERR_CANNOT_POSTDATE);
        }
        KerberosTime renewalTime = null;
        KerberosTime kerberosEndTime = null;
        if (request.getKdcReqBody().getKdcOptions().get(30)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isRenewable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (tgt.getEncTicketPart().getRenewTill().lessThan(now)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
            }
            TicketGrantingService.echoTicket(newTicketPart, tgt);
            newTicketPart.setStartTime(now);
            KerberosTime tgtStartTime = tgt.getEncTicketPart().getStartTime() != null ? tgt.getEncTicketPart().getStartTime() : tgt.getEncTicketPart().getAuthTime();
            long oldLife = tgt.getEncTicketPart().getEndTime().getTime() - tgtStartTime.getTime();
            kerberosEndTime = new KerberosTime(Math.min(tgt.getEncTicketPart().getRenewTill().getTime(), now.getTime() + oldLife));
            newTicketPart.setEndTime(kerberosEndTime);
        } else {
            if (newTicketPart.getStartTime() == null) {
                newTicketPart.setStartTime(now);
            }
            KerberosTime till = request.getKdcReqBody().getTill().isZero() ? KerberosTime.INFINITY : request.getKdcReqBody().getTill();
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            minimizer.add(till);
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumTicketLifetime()));
            minimizer.add(tgt.getEncTicketPart().getEndTime());
            kerberosEndTime = (KerberosTime)Collections.min(minimizer);
            newTicketPart.setEndTime(kerberosEndTime);
            if (request.getKdcReqBody().getKdcOptions().get(27) && kerberosEndTime.lessThan(request.getKdcReqBody().getTill()) && tgt.getEncTicketPart().getFlags().isRenewable()) {
                if (!config.isRenewableAllowed()) {
                    throw new KerberosException(ErrorType.KDC_ERR_POLICY);
                }
                request.getKdcReqBody().getKdcOptions().set(8);
                long rtime = Math.min(request.getKdcReqBody().getTill().getTime(), tgt.getEncTicketPart().getRenewTill().getTime());
                renewalTime = new KerberosTime(rtime);
            }
        }
        if (renewalTime == null) {
            renewalTime = request.getKdcReqBody().getRTime();
        }
        KerberosTime rtime = renewalTime != null && renewalTime.isZero() ? KerberosTime.INFINITY : renewalTime;
        if (request.getKdcReqBody().getKdcOptions().get(8) && tgt.getEncTicketPart().getFlags().isRenewable()) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketPart.setFlag(TicketFlag.RENEWABLE);
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            if (rtime != null) {
                minimizer.add(rtime);
            }
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumRenewableLifetime()));
            minimizer.add(tgt.getEncTicketPart().getRenewTill());
            newTicketPart.setRenewTill((KerberosTime)Collections.min(minimizer));
        }
        if (kerberosEndTime.lessThan(startTime)) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
        long ticketLifeTime = Math.abs(startTime.getTime() - kerberosEndTime.getTime());
        if (ticketLifeTime < config.getAllowableClockSkew()) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
    }

    private static void processTransited(EncTicketPart newTicketPart, Ticket tgt) {
        newTicketPart.setTransited(tgt.getEncTicketPart().getTransited());
    }

    private static void echoTicket(EncTicketPart newTicketPart, Ticket tgt) {
        EncTicketPart encTicketpart = tgt.getEncTicketPart();
        newTicketPart.setAuthorizationData(encTicketpart.getAuthorizationData());
        newTicketPart.setAuthTime(encTicketpart.getAuthTime());
        newTicketPart.setClientAddresses(encTicketpart.getClientAddresses());
        newTicketPart.setCName(encTicketpart.getCName());
        newTicketPart.setEndTime(encTicketpart.getEndTime());
        newTicketPart.setFlags(encTicketpart.getFlags());
        newTicketPart.setRenewTill(encTicketpart.getRenewTill());
        newTicketPart.setKey(encTicketpart.getKey());
        newTicketPart.setTransited(encTicketpart.getTransited());
    }

    public static PrincipalStoreEntry getEntry(KerberosPrincipal principal, PrincipalStore store, ErrorType errorType) throws KerberosException {
        PrincipalStoreEntry entry = null;
        try {
            entry = store.getPrincipal(principal);
        }
        catch (Exception e) {
            throw new KerberosException(errorType, (Throwable)e);
        }
        if (entry == null) {
            throw new KerberosException(errorType);
        }
        if (entry.getKeyMap() == null || entry.getKeyMap().isEmpty()) {
            throw new KerberosException(ErrorType.KDC_ERR_NULL_KEY);
        }
        return entry;
    }

    public static Authenticator verifyAuthHeader(ApReq authHeader, Ticket ticket, EncryptionKey serverKey, long clockSkew, ReplayCache replayCache, boolean emptyAddressesAllowed, InetAddress clientAddress, CipherTextHandler lockBox, KeyUsage authenticatorKeyUsage, boolean isValidate) throws KerberosException {
        KerberosTime now;
        if (authHeader.getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        if (authHeader.getMessageType() != KerberosMessageType.AP_REQ) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
        }
        if (authHeader.getTicket().getTktVno() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        EncryptionKey ticketKey = null;
        ticketKey = authHeader.getOption(1) ? authHeader.getTicket().getEncTicketPart().getKey() : serverKey;
        if (ticketKey == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOKEY);
        }
        byte[] encTicketPartData = lockBox.decrypt(ticketKey, ticket.getEncPart(), KeyUsage.AS_OR_TGS_REP_TICKET_WITH_SRVKEY);
        EncTicketPart encPart = KerberosDecoder.decodeEncTicketPart(encTicketPartData);
        ticket.setEncTicketPart(encPart);
        byte[] authenticatorData = lockBox.decrypt(ticket.getEncTicketPart().getKey(), authHeader.getAuthenticator(), authenticatorKeyUsage);
        Authenticator authenticator = KerberosDecoder.decodeAuthenticator(authenticatorData);
        if (!authenticator.getCName().getNameString().equals(ticket.getEncTicketPart().getCName().getNameString())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADMATCH);
        }
        if (ticket.getEncTicketPart().getClientAddresses() != null ? !ticket.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress)) : !emptyAddressesAllowed) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADADDR);
        }
        KerberosPrincipal serverPrincipal = KerberosUtils.getKerberosPrincipal(ticket.getSName(), ticket.getRealm());
        KerberosPrincipal clientPrincipal = KerberosUtils.getKerberosPrincipal(authenticator.getCName(), authenticator.getCRealm());
        KerberosTime clientTime = authenticator.getCtime();
        int clientMicroSeconds = authenticator.getCusec();
        if (replayCache != null) {
            if (replayCache.isReplay(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_REPEAT);
            }
            replayCache.save(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        }
        if (!authenticator.getCtime().isInClockSkew(clockSkew)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_SKEW);
        }
        KerberosTime startTime = ticket.getEncTicketPart().getStartTime() != null ? ticket.getEncTicketPart().getStartTime() : ticket.getEncTicketPart().getAuthTime();
        boolean isValidStartTime = startTime.lessThan(now = new KerberosTime());
        if (!isValidStartTime || ticket.getEncTicketPart().getFlags().isInvalid() && !isValidate) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
        }
        if (!ticket.getEncTicketPart().getEndTime().greaterThan(now)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
        }
        authHeader.getApOptions().set(2);
        return authenticator;
    }
}

