/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.evaluator.GreaterEqEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreaterEqCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = "GreaterEqCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final GreaterEqEvaluator<V> greaterEqEvaluator;
    private final Cursor<IndexEntry<V, String>> userIdxCursor;
    private final Cursor<IndexEntry<String, String>> uuidIdxCursor;
    private IndexEntry<String, String> uuidCandidate;

    public GreaterEqCursor(Store store, GreaterEqEvaluator<V> greaterEqEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating GreaterEqCursor {}", (Object)this);
        }
        this.greaterEqEvaluator = greaterEqEvaluator;
        AttributeType attributeType = greaterEqEvaluator.getExpression().getAttributeType();
        if (store.hasIndexOn(attributeType)) {
            this.userIdxCursor = store.getIndex(attributeType).forwardCursor();
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = new AllEntriesCursor(store);
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void before(IndexEntry<V, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(element.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue()) <= 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.before(element);
            this.setAvailable(false);
        } else {
            super.before(element);
        }
    }

    @Override
    public void after(IndexEntry<V, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(element.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue == 0) {
                this.userIdxCursor.after(element);
                this.setAvailable(false);
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.after(element);
            this.setAvailable(false);
        } else {
            super.after(element);
        }
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            IndexEntry advanceTo = new IndexEntry();
            advanceTo.setKey(this.greaterEqEvaluator.getExpression().getValue().getValue());
            this.userIdxCursor.before(advanceTo);
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.previous()) {
                this.checkNotClosed("previous()");
                IndexEntry<V, String> candidate = this.userIdxCursor.get();
                if (this.greaterEqEvaluator.getComparator().compare(candidate.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue()) < 0) continue;
                return this.setAvailable(true);
            }
            return this.setAvailable(false);
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.uuidCandidate = this.uuidIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.uuidCandidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            return this.setAvailable(this.userIdxCursor.next());
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.uuidCandidate = this.uuidIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.uuidCandidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available()) {
                return this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
        }
        if (this.available()) {
            return this.uuidCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing GreaterEqCursor {}", (Object)this);
        }
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
            this.uuidCandidate = null;
        }
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing GreaterEqCursor {}", (Object)this);
        }
        super.close(cause);
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close(cause);
        } else {
            this.uuidIdxCursor.close(cause);
            this.uuidCandidate = null;
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("GreaterEqCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#candidate<").append(this.uuidCandidate).append(">:\n");
        sb.append(tabs + "  >>").append(this.greaterEqEvaluator).append('\n');
        if (this.userIdxCursor != null) {
            sb.append(tabs + "  <user>\n");
            sb.append(this.userIdxCursor.toString(tabs + "    "));
        }
        if (this.uuidIdxCursor != null) {
            sb.append(tabs + "  <uuid>\n");
            sb.append(this.uuidIdxCursor.toString(tabs + "  "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

