/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.IOException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.changepwd.ChangePasswordServer;
import org.apache.directory.server.kerberos.kdc.DirectoryPrincipalStore;
import org.apache.directory.server.kerberos.protocol.KerberosProtocolHandler;
import org.apache.directory.server.kerberos.protocol.codec.KerberosProtocolCodecFactory;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCacheImpl;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdcServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 522567370475574165L;
    private static final Logger LOG = LoggerFactory.getLogger(KdcServer.class);
    private static final String SERVICE_NAME = "Keydap Kerberos Service";
    private ReplayCache replayCache;
    private KerberosConfig config;
    private ChangePasswordServer changePwdServer;

    public KdcServer() {
        this(new KerberosConfig());
    }

    public KdcServer(KerberosConfig config) {
        this.config = config;
        super.setServiceName(SERVICE_NAME);
        super.setSearchBaseDn(config.getSearchBaseDn());
    }

    public ReplayCache getReplayCache() {
        return this.replayCache;
    }

    @Override
    public void start() throws IOException, LdapInvalidDnException {
        DirectoryPrincipalStore store = new DirectoryPrincipalStore(this.getDirectoryService(), new Dn(this.getSearchBaseDn()));
        LOG.debug("initializing the kerberos replay cache");
        this.replayCache = new ReplayCacheImpl(this.config.getAllowableClockSkew());
        for (Transport transport : this.transports) {
            IoAcceptor acceptor = transport.getAcceptor();
            DefaultIoFilterChainBuilder chainBuilder = new DefaultIoFilterChainBuilder();
            if (transport instanceof TcpTransport) {
                acceptor.setCloseOnDeactivation(false);
                ((NioSocketAcceptor)acceptor).getSessionConfig().setTcpNoDelay(true);
                ((NioSocketAcceptor)acceptor).setReuseAddress(true);
                ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setReadBufferSize(32768);
                ((AbstractSocketSessionConfig)acceptor.getSessionConfig()).setSendBufferSize(32768);
            } else {
                ((AbstractDatagramSessionConfig)acceptor.getSessionConfig()).setReadBufferSize(32768);
                ((AbstractDatagramSessionConfig)acceptor.getSessionConfig()).setSendBufferSize(32768);
            }
            chainBuilder.addFirst("codec", new ProtocolCodecFilter(KerberosProtocolCodecFactory.getInstance()));
            acceptor.setFilterChainBuilder(chainBuilder);
            acceptor.setHandler(new KerberosProtocolHandler(this, store));
            acceptor.bind();
        }
        LOG.info("Kerberos service started.");
        if (this.changePwdServer != null) {
            this.changePwdServer.setSearchBaseDn(this.getSearchBaseDn());
            this.changePwdServer.start();
        }
    }

    @Override
    public void stop() {
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            if (acceptor == null) continue;
            acceptor.dispose();
        }
        if (this.replayCache != null) {
            this.replayCache.clear();
        }
        LOG.info("Kerberos service stopped.");
        if (this.changePwdServer != null) {
            this.changePwdServer.stop();
        }
    }

    public int getTcpPort() {
        for (Transport t : this.transports) {
            if (!(t instanceof TcpTransport)) continue;
            return t.getPort();
        }
        return -1;
    }

    public KerberosConfig getConfig() {
        return this.config;
    }

    public ChangePasswordServer getChangePwdServer() {
        return this.changePwdServer;
    }

    public void setChangePwdServer(ChangePasswordServer changePwdServer) {
        this.changePwdServer = changePwdServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KDCServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

