/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.List;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;

public class OrNode
extends BranchNode {
    public OrNode(List<ExprNode> childList) {
        super(AssertionType.OR, childList);
    }

    public OrNode(ExprNode ... childList) {
        super(AssertionType.OR, childList);
    }

    public OrNode() {
        super(AssertionType.OR);
    }

    public AssertionType getOperator() {
        return AssertionType.OR;
    }

    public boolean isDisjunction() {
        return true;
    }

    public boolean isConjunction() {
        return false;
    }

    public boolean isNegation() {
        return false;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        buf.append("or: {");
        boolean isFirst = true;
        for (ExprNode node : this.children) {
            if (isFirst) {
                isFirst = false;
                buf.append(' ');
            } else {
                buf.append(", ");
            }
            node.printRefinementToBuffer(buf);
        }
        buf.append(" }");
        return buf;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(|");
        buf.append(super.toString());
        for (ExprNode child : this.getChildren()) {
            buf.append(child);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + AssertionType.OR.hashCode();
        hash = hash * 17 + (this.annotations == null ? 0 : this.annotations.hashCode());
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrNode)) {
            return false;
        }
        OrNode otherExprNode = (OrNode)other;
        List<ExprNode> otherChildren = otherExprNode.getChildren();
        if (otherChildren == this.children) {
            return true;
        }
        if (this.children.size() != otherChildren.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            ExprNode otherChild;
            ExprNode child = (ExprNode)this.children.get(i2);
            if (child.equals(otherChild = otherChildren.get(i2))) continue;
            return false;
        }
        return true;
    }
}

