/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.ComplexDnParser;
import org.apache.directory.api.ldap.model.name.FastDnParser;
import org.apache.directory.api.ldap.model.name.TooComplexDnException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Hex;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdn
implements Cloneable,
Externalizable,
Iterable<Ava>,
Comparable<Rdn> {
    protected static final Logger LOG = LoggerFactory.getLogger(Rdn.class);
    public static final Rdn EMPTY_RDN = new Rdn();
    private static final long serialVersionUID = 1L;
    String upName = null;
    String normName;
    transient List<Ava> avas = null;
    transient Map<String, List<Ava>> avaTypes;
    String avaType = null;
    Ava ava = null;
    int nbAvas = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUAL = 0;
    private boolean normalized = false;
    private transient SchemaManager schemaManager;
    private volatile int h;

    public Rdn() {
        this((SchemaManager)null);
    }

    public Rdn(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
        this.normalized = schemaManager != null;
        this.h = 0;
    }

    public Rdn(SchemaManager schemaManager, String rdn) throws LdapInvalidDnException {
        this.schemaManager = schemaManager;
        if (Strings.isNotEmpty(rdn)) {
            Rdn.parse(schemaManager, rdn, this);
            if (this.upName.length() < rdn.length()) {
                throw new LdapInvalidDnException(I18n.err(I18n.ERR_13625_INVALID_RDN, new Object[0]));
            }
            this.upName = rdn;
        } else {
            this.upName = "";
            this.normName = "";
            this.normalized = true;
        }
        this.hashCode();
    }

    public Rdn(String rdn) throws LdapInvalidDnException {
        this((SchemaManager)null, rdn);
    }

    public Rdn(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(upType);
            this.addAVA(schemaManager, upType, new Value(attributeType, upValue));
        } else {
            this.addAVA(schemaManager, upType, new Value(upValue));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(upType).append('=').append(upValue);
        this.upName = sb.toString();
        sb.setLength(0);
        sb.append(this.ava.getNormType()).append('=');
        Value value = this.ava.getValue();
        if (value != null) {
            sb.append(value.getNormalized());
        }
        this.normName = sb.toString();
        this.normalized = true;
        this.hashCode();
    }

    public Rdn(String upType, String upValue) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        this(null, upType, upValue);
    }

    public Rdn(SchemaManager schemaManager, Ava ... avas) throws LdapInvalidDnException {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < avas.length; ++i2) {
            if (i2 > 0) {
                buffer.append('+');
            }
            this.addAVA(schemaManager, avas[i2]);
            buffer.append(avas[i2].getName());
        }
        this.setUpName(buffer.toString());
        this.hashCode();
    }

    public Rdn(Ava ... avas) throws LdapInvalidDnException {
        this((SchemaManager)null, avas);
    }

    public Rdn(Rdn rdn) {
        this.nbAvas = rdn.size();
        this.upName = rdn.getName();
        this.normName = rdn.getName();
        this.normalized = rdn.normalized;
        this.schemaManager = rdn.schemaManager;
        switch (rdn.size()) {
            case 0: {
                this.hashCode();
                return;
            }
            case 1: {
                this.ava = rdn.ava.clone();
                this.hashCode();
                return;
            }
        }
        this.avas = new ArrayList<Ava>();
        this.avaTypes = new HashMap<String, List<Ava>>();
        for (Ava currentAva : rdn.avas) {
            this.avas.add(currentAva);
            List<Ava> avaList = this.avaTypes.get(currentAva.getNormType());
            if (avaList == null) {
                avaList = new ArrayList<Ava>();
                avaList.add(currentAva);
                this.avaTypes.put(currentAva.getNormType(), avaList);
                this.avas.add(currentAva);
                continue;
            }
            if (avaList.contains(currentAva)) continue;
            avaList.add(currentAva);
            this.avas.add(currentAva);
        }
        this.hashCode();
    }

    public Rdn(SchemaManager schemaManager, Rdn rdn) throws LdapInvalidDnException {
        this.nbAvas = rdn.size();
        this.upName = rdn.getName();
        this.schemaManager = schemaManager;
        this.normalized = rdn.normalized;
        switch (rdn.size()) {
            case 0: {
                this.hashCode();
                return;
            }
            case 1: {
                this.ava = new Ava(schemaManager, rdn.ava);
                StringBuilder sb = new StringBuilder();
                sb.append(this.ava.getNormType());
                sb.append('=');
                if (this.ava.getValue() != null && this.ava.getValue().getNormalized() != null) {
                    sb.append(this.ava.getValue().getNormalized());
                }
                this.normName = sb.toString();
                this.normalized = true;
                this.hashCode();
                return;
            }
        }
        this.avas = new ArrayList<Ava>();
        this.avaTypes = new HashMap<String, List<Ava>>();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        Iterator<Ava> iterator = rdn.avas.iterator();
        while (iterator.hasNext()) {
            List<Ava> avaList;
            Ava currentAva;
            Ava tmpAva = currentAva = iterator.next();
            if (!currentAva.isSchemaAware() && schemaManager != null) {
                tmpAva = new Ava(schemaManager, currentAva);
            }
            boolean empty = (avaList = this.avaTypes.get(tmpAva.getNormType())) == null;
            avaList = Rdn.addOrdered(avaList, tmpAva);
            if (empty) {
                this.avaTypes.put(tmpAva.getNormType(), avaList);
            }
            Rdn.addOrdered(this.avas, tmpAva);
        }
        for (Ava ava : this.avas) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('+');
            }
            sb.append(ava.getNormType());
            sb.append('=');
            if (ava.getValue() == null || ava.getValue().getNormalized() == null) continue;
            sb.append(ava.getValue().getNormalized());
        }
        this.normName = sb.toString();
        this.normalized = true;
        this.hashCode();
    }

    static List<Ava> addOrdered(List<Ava> avaList, Ava newAva) throws LdapInvalidDnException {
        if (avaList == null) {
            avaList = new ArrayList<Ava>();
        }
        if (avaList.isEmpty()) {
            avaList.add(newAva);
            return avaList;
        }
        int pos = 0;
        boolean found = false;
        for (Ava avaElem : avaList) {
            int comp = newAva.compareTo(avaElem);
            if (comp < 0) {
                avaList.add(pos, newAva);
                found = true;
                break;
            }
            if (comp == 0) {
                found = true;
                throw new LdapInvalidDnException(I18n.err(I18n.ERR_13626_INVALID_RDN_DUPLICATE_AVA, avaElem.normType));
            }
            ++pos;
        }
        if (!found) {
            avaList.add(newAva);
        }
        return avaList;
    }

    private void addAVA(SchemaManager schemaManager, String type, Value value) throws LdapInvalidDnException {
        List<Ava> avaList;
        String normalizedType = Strings.lowerCaseAscii(type);
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(normalizedType);
            if (!value.isSchemaAware()) {
                if (attributeType != null) {
                    try {
                        value = new Value(attributeType, value);
                    }
                    catch (LdapInvalidAttributeValueException liave) {
                        throw new LdapInvalidDnException(liave.getMessage(), liave);
                    }
                }
            } else if (attributeType != null) {
                normalizedType = attributeType.getOid();
            }
        }
        Ava newAva = new Ava(schemaManager, type, normalizedType, value);
        switch (this.nbAvas) {
            case 0: {
                this.ava = newAva;
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                if (this.ava.equals(newAva)) {
                    return;
                }
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new HashMap<String, List<Ava>>();
                avaList = new ArrayList<Ava>();
                this.avas.add(this.ava);
                avaList.add(this.ava);
                this.avaTypes.put(this.avaType, avaList);
                ++this.nbAvas;
                this.ava = null;
            }
        }
        avaList = this.avaTypes.get(newAva.getNormType());
        if (avaList == null) {
            avaList = new ArrayList<Ava>();
            avaList.add(newAva);
            this.avaTypes.put(newAva.getNormType(), avaList);
            this.avas.add(newAva);
            ++this.nbAvas;
        } else if (!avaList.contains(newAva)) {
            avaList.add(newAva);
            this.avas.add(newAva);
            ++this.nbAvas;
        }
    }

    void addAVA(SchemaManager schemaManager, Ava addedAva) throws LdapInvalidDnException {
        List<Ava> avaList;
        this.schemaManager = schemaManager;
        if (!addedAva.isSchemaAware() && schemaManager != null) {
            addedAva = new Ava(schemaManager, addedAva);
        }
        String normalizedType = addedAva.getNormType();
        switch (this.nbAvas) {
            case 0: {
                this.ava = addedAva;
                this.nbAvas = 1;
                this.avaType = normalizedType;
                this.hashCode();
                return;
            }
            case 1: {
                if (this.ava.equals(addedAva)) {
                    throw new LdapInvalidDnException(I18n.err(I18n.ERR_13626_INVALID_RDN_DUPLICATE_AVA, normalizedType));
                }
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new HashMap<String, List<Ava>>();
                avaList = new ArrayList<Ava>();
                this.avas.add(this.ava);
                avaList.add(this.ava);
                this.avaTypes.put(this.ava.getNormType(), avaList);
                this.ava = null;
            }
        }
        avaList = this.avaTypes.get(addedAva.getNormType());
        if (avaList == null) {
            avaList = new ArrayList<Ava>();
            avaList.add(addedAva);
            this.avaTypes.put(addedAva.getNormType(), avaList);
            this.avas.add(addedAva);
            ++this.nbAvas;
        } else {
            Rdn.addOrdered(avaList, addedAva);
            boolean found = false;
            for (int pos = 0; pos < this.avas.size(); ++pos) {
                int comp = addedAva.compareTo(this.avas.get(pos));
                if (comp < 0) {
                    this.avas.add(pos, addedAva);
                    found = true;
                    ++this.nbAvas;
                    break;
                }
                if (comp != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                this.avas.add(addedAva);
                ++this.nbAvas;
            }
        }
    }

    void clear() {
        this.ava = null;
        this.avas = null;
        this.avaType = null;
        this.avaTypes = null;
        this.nbAvas = 0;
        this.upName = "";
        this.normalized = false;
        this.h = 0;
    }

    public Object getValue(String type) throws LdapInvalidDnException {
        AttributeType attributeType;
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        if (this.schemaManager != null && (attributeType = this.schemaManager.getAttributeType(normalizedType)) != null) {
            normalizedType = attributeType.getOid();
        }
        switch (this.nbAvas) {
            case 0: {
                return "";
            }
            case 1: {
                if (this.ava.getNormType().equals(normalizedType)) {
                    if (this.ava.getValue() != null) {
                        return this.ava.getValue().getString();
                    }
                    return null;
                }
                return "";
            }
        }
        List<Ava> avaList = this.avaTypes.get(normalizedType);
        if (avaList != null) {
            for (Ava elem : avaList) {
                if (!elem.getNormType().equals(normalizedType)) continue;
                if (elem.getValue() != null) {
                    return elem.getValue().getString();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public Ava getAva(String type) {
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.ava.getNormType().equals(normalizedType)) {
                    return this.ava;
                }
                return null;
            }
        }
        List<Ava> avaList = this.avaTypes.get(normalizedType);
        if (avaList != null) {
            return avaList.get(0);
        }
        return null;
    }

    @Override
    public Iterator<Ava> iterator() {
        if (this.nbAvas < 2) {
            return new Iterator<Ava>(){
                private boolean hasMoreElement;
                {
                    this.hasMoreElement = Rdn.this.nbAvas == 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public Ava next() {
                    Ava obj = Rdn.this.ava;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.avas.iterator();
    }

    public Rdn clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            rdn.normalized = this.normalized;
            switch (rdn.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.ava = this.ava.clone();
                    rdn.avaTypes = this.avaTypes;
                    break;
                }
                default: {
                    rdn.avaTypes = new HashMap<String, List<Ava>>();
                    rdn.avas = new ArrayList<Ava>();
                    for (Ava currentAva : this.avas) {
                        rdn.avas.add(currentAva.clone());
                        ArrayList<Ava> avaList = new ArrayList<Ava>();
                        for (Ava elem : this.avaTypes.get(currentAva.getNormType())) {
                            avaList.add(elem.clone());
                        }
                        rdn.avaTypes.put(currentAva.getNormType(), avaList);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error(I18n.err(I18n.ERR_13621_ASSERTION_FAILURE, new Object[0]), cnse);
        }
    }

    public String getName() {
        return this.upName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public String getNormName() {
        return this.normName;
    }

    void setNormName(String normName) {
        this.normName = normName;
        this.normalized = true;
    }

    public Ava getAva() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava;
            }
        }
        return this.avas.get(0);
    }

    public Ava getAva(int pos) {
        if (pos > this.nbAvas) {
            return null;
        }
        if (pos == 0) {
            if (this.nbAvas == 1) {
                return this.ava;
            }
            return this.avas.get(0);
        }
        return this.avas.get(pos);
    }

    public String getType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getType();
            }
        }
        return this.avas.get(0).getType();
    }

    public String getNormType() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getNormType();
            }
        }
        return this.avas.get(0).getNormType();
    }

    public String getValue() {
        switch (this.nbAvas) {
            case 0: {
                return null;
            }
            case 1: {
                return this.ava.getValue().getString();
            }
        }
        return this.avas.get(0).getValue().getString();
    }

    public boolean equals(Object that) {
        Rdn rdn;
        if (this == that) {
            return true;
        }
        if (that instanceof String) {
            try {
                rdn = new Rdn(this.schemaManager, (String)that);
            }
            catch (LdapInvalidDnException e) {
                return false;
            }
        } else {
            if (!(that instanceof Rdn)) {
                return false;
            }
            rdn = (Rdn)that;
        }
        if (rdn.nbAvas != this.nbAvas) {
            return false;
        }
        switch (this.nbAvas) {
            case 0: {
                return true;
            }
            case 1: {
                return this.ava.equals(rdn.ava);
            }
        }
        for (Ava paramAva : rdn.avas) {
            List<Ava> avaList = this.avaTypes.get(paramAva.getNormType());
            if (avaList != null && avaList.contains(paramAva)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.nbAvas;
    }

    public static Object unescapeValue(String value) {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '\"' && chars[chars.length - 1] == '\"') {
            return new String(chars, 1, chars.length - 2);
        }
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return Strings.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13613_VALUE_NOT_IN_HEX_FORM_ODD_NUMBER, new Object[0]));
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i2 = 1; i2 < chars.length; i2 += 2) {
                if (!Chars.isHex(chars, i2) || !Chars.isHex(chars, i2 + 1)) {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_13614_VALUE_NOT_IN_HEX_FORM, new Object[0]));
                }
                hexValue[pos++] = Hex.getHexValue(chars[i2], chars[i2 + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block9: for (int i3 = 0; i3 < chars.length; ++i3) {
            if (escaped) {
                escaped = false;
                switch (chars[i3]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i3];
                        break;
                    }
                    default: {
                        if (!Chars.isHex(chars, i3)) continue block9;
                        isHex = true;
                        pair = (byte)(Hex.getHexValue(chars[i3]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!Chars.isHex(chars, i3)) continue;
                pair = (byte)(pair + Hex.getHexValue(chars[i3]));
                bytes[pos++] = pair;
                isHex = false;
                pair = 0;
                continue;
            }
            switch (chars[i3]) {
                case '\\': {
                    escaped = true;
                    continue block9;
                }
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': {
                    if (i3 == 0) continue block9;
                    bytes[pos++] = 35;
                    continue block9;
                }
                case ' ': {
                    if (i3 == 0 || i3 == chars.length - 1) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_13615_UNESCAPED_CHARS_NOT_ALLOWED, new Object[0]));
                    }
                    bytes[pos++] = 32;
                    continue block9;
                }
                default: {
                    if (chars[i3] < '\u0080') {
                        bytes[pos++] = (byte)chars[i3];
                        continue block9;
                    }
                    byte[] result = Unicode.charToBytes(chars[i3]);
                    System.arraycopy(result, 0, bytes, pos, result.length);
                    pos += result.length;
                }
            }
        }
        return Strings.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block8: for (int i2 = 0; i2 < chars.length; ++i2) {
            switch (chars[i2]) {
                case ' ': {
                    if (i2 > 0 && i2 < chars.length - 1) {
                        newChars[pos++] = chars[i2];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i2];
                    continue block8;
                }
                case '#': {
                    if (i2 != 0) {
                        newChars[pos++] = chars[i2];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i2];
                    continue block8;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i2];
                    continue block8;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block8;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i2] & 0xF));
                    continue block8;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i2] & 0xF));
                    continue block8;
                }
                default: {
                    newChars[pos++] = chars[i2];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public String getEscaped() {
        StringBuilder sb = new StringBuilder();
        switch (this.nbAvas) {
            case 0: {
                return "";
            }
            case 1: {
                sb.append(this.ava.getEscaped());
                break;
            }
            default: {
                boolean isFirst = true;
                for (Ava atav : this.avas) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(atav.getEscaped());
                }
            }
        }
        return sb.toString();
    }

    public static String escapeValue(byte[] attrValue) {
        if (Strings.isEmpty(attrValue)) {
            return "";
        }
        String value = Strings.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    public static boolean isValid(String rdn) {
        try {
            Rdn.parse(null, rdn, null);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    public static boolean isValid(SchemaManager schemaManager, String rdn) {
        try {
            Rdn.parse(schemaManager, rdn, null);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    private static void parse(SchemaManager schemaManager, String rdnStr, Rdn rdn) throws LdapInvalidDnException {
        try {
            FastDnParser.parseRdn(schemaManager, rdnStr, rdn);
        }
        catch (TooComplexDnException e) {
            if (rdn != null) {
                rdn.clear();
            } else {
                rdn = new Rdn();
            }
            new ComplexDnParser().parseRdn(schemaManager, rdnStr, rdn);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            int hTmp = 37;
            switch (this.nbAvas) {
                case 0: {
                    break;
                }
                case 1: {
                    this.h = hTmp * 17 + this.ava.hashCode();
                    break;
                }
                default: {
                    for (Ava ata : this.avas) {
                        this.h = hTmp * 17 + ata.hashCode();
                    }
                }
            }
        }
        return this.h;
    }

    public int serialize(byte[] buffer, int pos) throws IOException {
        byte[] upNameBytes;
        int length = 8;
        if (buffer.length - (pos = Serialize.serialize(this.nbAvas, buffer, pos)) < (length += 4 + (upNameBytes = Strings.getBytesUtf8(this.upName)).length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        pos = Serialize.serialize(upNameBytes, buffer, pos);
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                pos = this.ava.serialize(buffer, pos);
                break;
            }
            default: {
                for (Ava localAva : this.avas) {
                    pos = localAva.serialize(buffer, pos);
                }
            }
        }
        pos = Serialize.serialize(this.h, buffer, pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nbAvas = Serialize.deserializeInt(buffer, pos);
        byte[] upNameBytes = Serialize.deserializeBytes(buffer, pos += 4);
        pos += 4 + upNameBytes.length;
        this.upName = Strings.utf8ToString(upNameBytes);
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                this.ava = new Ava(this.schemaManager);
                pos = this.ava.deserialize(buffer, pos);
                this.avaType = this.ava.getNormType();
                break;
            }
            default: {
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new HashMap<String, List<Ava>>();
                for (int i2 = 0; i2 < this.nbAvas; ++i2) {
                    Ava newAva = new Ava(this.schemaManager);
                    pos = newAva.deserialize(buffer, pos);
                    this.avas.add(newAva);
                    List<Ava> avaList = this.avaTypes.get(newAva.getNormType());
                    if (avaList == null) {
                        avaList = new ArrayList<Ava>();
                        this.avaTypes.put(newAva.getNormType(), avaList);
                    }
                    avaList.add(newAva);
                }
                this.ava = null;
                this.avaType = null;
            }
        }
        this.h = Serialize.deserializeInt(buffer, pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nbAvas);
        out.writeUTF(this.upName);
        switch (this.nbAvas) {
            case 0: {
                break;
            }
            case 1: {
                this.ava.writeExternal(out);
                break;
            }
            default: {
                for (Ava localAva : this.avas) {
                    localAva.writeExternal(out);
                }
            }
        }
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        StringBuilder sb = new StringBuilder();
        this.nbAvas = in.readInt();
        this.upName = in.readUTF();
        switch (this.nbAvas) {
            case 0: {
                this.ava = null;
                this.normName = "";
                break;
            }
            case 1: {
                this.ava = new Ava(this.schemaManager);
                this.ava.readExternal(in);
                this.avaType = this.ava.getNormType();
                this.buildNormRdn(sb, this.ava);
                this.normName = sb.toString();
                break;
            }
            default: {
                this.avas = new ArrayList<Ava>();
                this.avaTypes = new HashMap<String, List<Ava>>();
                boolean isFirst = true;
                for (int i2 = 0; i2 < this.nbAvas; ++i2) {
                    Ava newAva = new Ava(this.schemaManager);
                    newAva.readExternal(in);
                    this.avas.add(newAva);
                    List<Ava> avaList = this.avaTypes.get(newAva.getNormType());
                    if (avaList == null) {
                        avaList = new ArrayList<Ava>();
                        this.avaTypes.put(newAva.getNormType(), avaList);
                    }
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    this.buildNormRdn(sb, newAva);
                    avaList.add(newAva);
                }
                this.ava = null;
                this.avaType = null;
                this.normName = sb.toString();
            }
        }
        this.h = in.readInt();
    }

    private void buildNormRdn(StringBuilder sb, Ava ava) {
        sb.append(ava.getNormType());
        sb.append('=');
        Value val = ava.getValue();
        if (val != null && val.getNormalized() != null) {
            sb.append(ava.getValue().getNormalized());
        }
    }

    @Override
    public int compareTo(Rdn otherRdn) {
        if (otherRdn == null) {
            return 1;
        }
        if (this.nbAvas < otherRdn.nbAvas) {
            return -1;
        }
        if (this.nbAvas > otherRdn.nbAvas) {
            return 1;
        }
        switch (this.nbAvas) {
            case 0: {
                return 0;
            }
            case 1: {
                int comp = this.ava.compareTo(otherRdn.ava);
                if (comp < 0) {
                    return -1;
                }
                if (comp > 0) {
                    return 1;
                }
                return 0;
            }
        }
        if (this.isSchemaAware()) {
            return this.normName.compareTo(otherRdn.normName);
        }
        int pos = 0;
        for (Ava atav : this.avas) {
            Ava otherAva;
            int comp = atav.compareTo(otherAva = otherRdn.avas.get(pos));
            if (comp != 0) {
                if (comp < 0) {
                    return -1;
                }
                return 1;
            }
            ++pos;
        }
        return 0;
    }

    public String toString() {
        return this.upName == null ? "" : this.upName;
    }
}

