/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;

public class RegexNormalizer
extends Normalizer {
    private final Pattern[] regexes;
    private final transient Matcher[] matchers;

    public RegexNormalizer(String oid, Pattern[] regexes) {
        super(oid);
        if (regexes != null) {
            this.regexes = new Pattern[regexes.length];
            System.arraycopy(regexes, 0, this.regexes, 0, regexes.length);
            this.matchers = new Matcher[regexes.length];
            for (int i2 = 0; i2 < regexes.length; ++i2) {
                this.matchers[i2] = regexes[i2].matcher("");
            }
        } else {
            this.regexes = null;
            this.matchers = new Matcher[0];
        }
    }

    @Override
    public String normalize(String value) {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) {
        if (value == null) {
            return null;
        }
        String str = value;
        for (int i2 = 0; i2 < this.matchers.length; ++i2) {
            str = this.matchers[i2].replaceAll(str);
        }
        return str;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("RegexNormalizer( ");
        for (int i2 = 0; i2 < this.regexes.length; ++i2) {
            buf.append(this.regexes[i2]);
            if (i2 >= this.regexes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(" )");
        return buf.toString();
    }
}

