/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class OidLenSyntaxChecker
extends SyntaxChecker {
    public static final OidLenSyntaxChecker INSTANCE = new OidLenSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.5");

    private OidLenSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int pos = strValue.indexOf(123);
        if (pos < 0) {
            boolean result = Oid.isOid(strValue);
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
                } else {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
            }
            return result;
        }
        String oid = strValue.substring(0, pos);
        if (!Oid.isOid(oid)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        String len = strValue.substring(pos);
        if (len.charAt(len.length() - 1) != '}') {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        block3: for (int i2 = 1; i2 < len.length() - 1; ++i2) {
            switch (len.charAt(i2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                    }
                    return false;
                }
            }
        }
        if (len.charAt(1) == '0' && len.length() > 3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<OidLenSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.5");
        }

        @Override
        public OidLenSyntaxChecker build() {
            return new OidLenSyntaxChecker(this.oid);
        }
    }
}

