/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.changelog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.LdapPrincipalSerializer;
import org.apache.directory.server.core.api.changelog.ChangeLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeLogEventSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(ChangeLogEventSerializer.class);

    private ChangeLogEventSerializer() {
    }

    public static void serialize(ChangeLogEvent event, ObjectOutput out) throws IOException {
        out.writeUTF(event.getZuluTime());
        LdapPrincipalSerializer.serialize(event.getCommitterPrincipal(), out);
        out.writeLong(event.getRevision());
        event.getForwardLdif().writeExternal(out);
        int nbReverses = event.getReverseLdifs().size();
        out.writeInt(nbReverses);
        for (LdifEntry reverseLdif : event.getReverseLdifs()) {
            reverseLdif.writeExternal(out);
        }
        out.flush();
    }

    public static ChangeLogEvent deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException {
        String zuluTime = in.readUTF();
        LdapPrincipal committerPrincipal = LdapPrincipalSerializer.deserialize(schemaManager, in);
        long revision = in.readLong();
        LdifEntry forwardEntry = new LdifEntry();
        try {
            forwardEntry.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException(cnfe.getMessage());
            ioe.initCause(cnfe);
            throw ioe;
        }
        int nbReverses = in.readInt();
        ArrayList<LdifEntry> reverses = new ArrayList<LdifEntry>(nbReverses);
        for (int i2 = 0; i2 < nbReverses; ++i2) {
            LdifEntry reverseEntry = new LdifEntry();
            try {
                reverseEntry.readExternal(in);
            }
            catch (ClassNotFoundException cnfe) {
                IOException ioe = new IOException(cnfe.getMessage());
                ioe.initCause(cnfe);
                throw ioe;
            }
            reverses.add(reverseEntry);
        }
        return new ChangeLogEvent(revision, zuluTime, committerPrincipal, forwardEntry, reverses);
    }
}

