/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;

public class HighestPrecedenceFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        ACI_LOG.debug("Filtering HighestPrecedence...");
        if (aciContext.getAciTuples().size() <= 1) {
            ACI_LOG.debug("HighestPrecedence : nothing to do");
            return aciContext.getAciTuples();
        }
        int maxPrecedence = -1;
        for (ACITuple tuple : aciContext.getAciTuples()) {
            if (tuple.getPrecedence() == null || tuple.getPrecedence() <= maxPrecedence) continue;
            maxPrecedence = tuple.getPrecedence();
        }
        Iterator<ACITuple> i2 = aciContext.getAciTuples().iterator();
        while (i2.hasNext()) {
            ACITuple tuple;
            tuple = i2.next();
            if (tuple.getPrecedence() == null || tuple.getPrecedence() == maxPrecedence) continue;
            i2.remove();
        }
        return aciContext.getAciTuples();
    }
}

