/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTupleValueCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final ValueCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleValueCursor(ValueCursor<V> cursor, K key) {
        this.key = key;
        this.wrapped = cursor;
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyTupleArrayCursor {}", (Object)this);
        }
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void before(Tuple<K, V> element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void after(Tuple<K, V> element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        try {
            if (this.wrapped.hasPrev()) {
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(this.wrapped.prev());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        try {
            if (this.wrapped.hasNext()) {
                this.returnedTuple.setKey(this.key);
                this.returnedTuple.setValue(this.wrapped.next());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public Tuple<K, V> get() throws CursorException {
        this.checkNotClosed();
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        super.close();
    }

    @Override
    public void close(Exception reason) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        super.close(reason);
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("KeyTupleArrayCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#").append(this.key);
        sb.append(" :\n");
        sb.append(this.wrapped.toString());
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

