/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.avl;

import java.io.File;
import org.apache.directory.server.core.partition.avl.AvlTable;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlIndex<K, O>
implements Index<K, O, Long> {
    private Normalizer normalizer;
    private AttributeType attributeType;
    private AvlTable<K, Long> forward;
    private AvlTable<Long, K> reverse;
    private String attributeId;

    public AvlIndex() {
    }

    public AvlIndex(String attributeId) {
        this.setAttributeId(attributeId);
    }

    void initialize(AttributeType attributeType) throws Exception {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new Exception(I18n.err((String)I18n.ERR_212, (Object[])new Object[]{attributeType}));
        }
        LdapComparator comp = mr.getLdapComparator();
        this.forward = new AvlTable(attributeType.getName(), comp, LongComparator.INSTANCE, true);
        this.reverse = attributeType.isSingleValued() ? new AvlTable(attributeType.getName(), LongComparator.INSTANCE, comp, false) : new AvlTable(attributeType.getName(), LongComparator.INSTANCE, comp, true);
    }

    public void add(K attrVal, Long id) throws Exception {
        this.forward.put(this.getNormalized(attrVal), id);
        this.reverse.put(id, (Long)this.getNormalized(attrVal));
    }

    public void close() throws Exception {
        this.forward.close();
        this.reverse.close();
    }

    public int count() throws Exception {
        return this.forward.count();
    }

    public int count(K attrVal) throws Exception {
        return this.forward.count(this.getNormalized(attrVal));
    }

    public void drop(Long id) throws Exception {
        Cursor<Tuple<Long, K>> cursor = this.reverse.cursor(id);
        while (cursor.next()) {
            Tuple tuple = (Tuple)cursor.get();
            this.forward.remove(tuple.getValue(), id);
        }
        this.reverse.remove(id);
    }

    public void drop(K attrVal, Long id) throws Exception {
        this.forward.remove(this.getNormalized(attrVal), id);
        this.reverse.remove(id, (Long)this.getNormalized(attrVal));
    }

    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(this.getNormalized(attrVal));
    }

    public boolean forward(K attrVal, Long id) throws Exception {
        return this.forward.has(this.getNormalized(attrVal), id);
    }

    public IndexCursor<K, O, Long> forwardCursor() throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    public IndexCursor<K, O, Long> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal));
    }

    public boolean forwardGreaterOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal), id);
    }

    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal));
    }

    public boolean forwardLessOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal), id);
    }

    public Long forwardLookup(K attrVal) throws Exception {
        return this.forward.get(this.getNormalized(attrVal));
    }

    public Cursor<Long> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    public AttributeType getAttribute() {
        return this.attributeType;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public K getNormalized(K attrVal) throws Exception {
        if (attrVal instanceof Long) {
            return attrVal;
        }
        if (attrVal instanceof String) {
            return (K)this.normalizer.normalize((String)attrVal);
        }
        return (K)this.normalizer.normalize((Value)new ClientBinaryValue((byte[])attrVal)).get();
    }

    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(this.getNormalized(attrVal));
    }

    public boolean isCountExact() {
        return false;
    }

    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(this.getNormalized(attrVal));
    }

    public boolean reverse(Long id) throws Exception {
        return this.reverse.has(id);
    }

    public boolean reverse(Long id, K attrVal) throws Exception {
        return this.reverse.has(id, (Long)this.getNormalized(attrVal));
    }

    public IndexCursor<K, O, Long> reverseCursor() throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(), false);
    }

    public IndexCursor<K, O, Long> reverseCursor(Long id) throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(id), false);
    }

    public boolean reverseGreaterOrEq(Long id) throws Exception {
        return this.reverse.hasGreaterOrEqual(id);
    }

    public boolean reverseGreaterOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasGreaterOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    public boolean reverseLessOrEq(Long id) throws Exception {
        return this.reverse.hasLessOrEqual(id);
    }

    public boolean reverseLessOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasLessOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    public K reverseLookup(Long id) throws Exception {
        return this.reverse.get(id);
    }

    public Cursor<K> reverseValueCursor(Long id) throws Exception {
        return this.reverse.valueCursor(id);
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    public void setWkDirPath(File wkDirPath) {
        throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_213, (Object[])new Object[0]));
    }

    public File getWkDirPath() {
        return null;
    }

    public void setCacheSize(int cacheSize) {
        throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_214, (Object[])new Object[0]));
    }

    public int getCacheSize() {
        return 0;
    }

    public void sync() throws Exception {
    }
}

