/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PrincipalNameDecoder;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class TicketDecoder {
    public static Ticket decode(byte[] encodedTicket) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedTicket);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        return TicketDecoder.decode(app);
    }

    public static Ticket[] decodeSequence(DERSequence sequence) throws IOException {
        Ticket[] tickets = new Ticket[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERApplicationSpecific object = (DERApplicationSpecific)e.nextElement();
            tickets[ii] = TicketDecoder.decode(object);
        }
        return tickets;
    }

    protected static Ticket decode(DERApplicationSpecific app) throws IOException {
        DERSequence sequence = (DERSequence)app.getObject();
        Ticket ticket = new Ticket();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    ticket.setTktVno(tag0.intValue());
                    break;
                }
                case 1: {
                    DERGeneralString tag1 = (DERGeneralString)derObject;
                    ticket.setRealm(tag1.getString());
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    ticket.setSName(PrincipalNameDecoder.decode(tag2));
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    ticket.setEncPart(EncryptedDataDecoder.decode(tag3));
                }
            }
        }
        return ticket;
    }
}

