/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorReply
extends CommandBase {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorReply.class);

    public boolean execute(Context context) throws Exception {
        KdcContext kdcContext = (KdcContext)context;
        KerberosMessage message = kdcContext.getReply();
        if (message instanceof KdcReply) {
            KdcReply reply = (KdcReply)message;
            if (log.isDebugEnabled()) {
                log.debug("Responding to authentication request with reply:\n\tclient realm:          " + reply.getClientRealm() + "\n\tserver realm:          " + reply.getServerRealm() + "\n\tserverPrincipal:       " + reply.getServerPrincipal() + "\n\tclientPrincipal:       " + reply.getClientPrincipal() + "\n\thostAddresses:         " + reply.getClientAddresses() + "\n\tstart time:            " + reply.getStartTime() + "\n\tend time:              " + reply.getEndTime() + "\n\tauth time:             " + reply.getAuthTime() + "\n\trenew till time:       " + reply.getRenewTill() + "\n\tmessageType:           " + reply.getMessageType() + "\n\tnonce:                 " + reply.getNonce() + "\n\tprotocolVersionNumber: " + reply.getProtocolVersionNumber());
            }
        } else if (message instanceof ErrorMessage) {
            ErrorMessage error = (ErrorMessage)message;
            if (log.isDebugEnabled()) {
                log.debug("Responding to authentication request with error:\n\tserverPrincipal:       " + error.getServerPrincipal() + "\n\tclientPrincipal:       " + error.getClientPrincipal() + "\n\tserver time:           " + error.getClientTime() + "\n\tclient time:           " + error.getServerTime() + "\n\terror code:            " + error.getErrorCode() + "\n\texplanatory text:      " + error.getExplanatoryText());
            }
        }
        return false;
    }
}

