/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.preauthentication;

import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.preauthentication.VerifierBase;
import org.apache.directory.server.kerberos.sam.SamException;
import org.apache.directory.server.kerberos.sam.SamSubsystem;
import org.apache.directory.server.kerberos.sam.TimestampChecker;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationData;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationDataType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySam
extends VerifierBase {
    private static final Logger log = LoggerFactory.getLogger((Class)VerifySam.class);

    public boolean execute(Context ctx) throws Exception {
        log.debug("Verifying using SAM subsystem.");
        AuthenticationContext authContext = (AuthenticationContext)ctx;
        KdcRequest request = authContext.getRequest();
        PrincipalStoreEntry clientEntry = authContext.getClientEntry();
        String clientName = clientEntry.getPrincipal().getName();
        EncryptionKey clientKey = null;
        if (clientEntry.getSamType() != null) {
            PreAuthenticationData[] preAuthData;
            if (log.isDebugEnabled()) {
                log.debug("entry for client principal " + clientName + " has a valid SAM type: invoking SAM subsystem for pre-authentication");
            }
            if ((preAuthData = request.getPreAuthData()) == null || preAuthData.length == 0) {
                throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError());
            }
            try {
                for (int ii = 0; ii < preAuthData.length; ++ii) {
                    if (!preAuthData[ii].getDataType().equals(PreAuthenticationDataType.PA_ENC_TIMESTAMP)) continue;
                    KerberosKey samKey = SamSubsystem.getInstance().verify(clientEntry, preAuthData[ii].getDataValue());
                    clientKey = new EncryptionKey(EncryptionType.getTypeByOrdinal((int)samKey.getKeyType()), samKey.getEncoded());
                }
            }
            catch (SamException se) {
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, se.getMessage());
            }
            authContext.setClientKey(clientKey);
            if (log.isDebugEnabled()) {
                log.debug("Pre-authentication using SAM subsystem successful for " + clientName + ".");
            }
        }
        return false;
    }

    static {
        log.debug("Initializing SAM subsystem");
        SamSubsystem.getInstance().setIntegrityChecker(new TimestampChecker());
    }
}

