/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.io.IOException;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.ApplicationRequestDecoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationData;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationDataType;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class GetAuthHeader
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)context;
        KdcRequest request = tgsContext.getRequest();
        ApplicationRequest authHeader = this.getAuthHeader(request);
        Ticket tgt = authHeader.getTicket();
        tgsContext.setAuthHeader(authHeader);
        tgsContext.setTgt(tgt);
        return false;
    }

    protected ApplicationRequest getAuthHeader(KdcRequest request) throws KerberosException, IOException {
        byte[] undecodedAuthHeader = null;
        PreAuthenticationData[] preAuthData = request.getPreAuthData();
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            if (preAuthData[ii].getDataType() != PreAuthenticationDataType.PA_TGS_REQ) continue;
            undecodedAuthHeader = preAuthData[ii].getDataValue();
        }
        if (undecodedAuthHeader == null) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        ApplicationRequestDecoder decoder = new ApplicationRequestDecoder();
        ApplicationRequest authHeader = decoder.decode(undecodedAuthHeader);
        return authHeader;
    }
}

