/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
extends CommandBase {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorContext.class);

    public boolean execute(Context context) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                TicketGrantingContext tgsContext = (TicketGrantingContext)context;
                PrincipalStore store = tgsContext.getStore();
                ApplicationRequest authHeader = tgsContext.getAuthHeader();
                Ticket tgt = tgsContext.getTgt();
                long clockSkew = tgsContext.getConfig().getClockSkew();
                ReplayCache replayCache = tgsContext.getReplayCache();
                ChecksumType checksumType = tgsContext.getAuthenticator().getChecksum().getChecksumType();
                InetAddress clientAddress = tgsContext.getClientAddress();
                HostAddresses clientAddresses = tgt.getClientAddresses();
                boolean caddrContainsSender = false;
                if (tgt.getClientAddresses() != null) {
                    caddrContainsSender = tgt.getClientAddresses().contains(new HostAddress(clientAddress));
                }
                StringBuffer sb = new StringBuffer();
                sb.append("\n\tstore                  " + store);
                sb.append("\n\tauthHeader             " + authHeader);
                sb.append("\n\ttgt                    " + tgt);
                sb.append("\n\treplayCache            " + replayCache);
                sb.append("\n\tclockSkew              " + clockSkew);
                sb.append("\n\tchecksumType           " + checksumType);
                sb.append("\n\tclientAddress          " + clientAddress);
                sb.append("\n\tclientAddresses        " + clientAddresses);
                sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
                KerberosPrincipal requestServerPrincipal = tgsContext.getRequest().getServerPrincipal();
                PrincipalStoreEntry requestPrincipal = tgsContext.getRequestPrincipalEntry();
                sb.append("\n\tprincipal              " + requestServerPrincipal);
                sb.append("\n\tcn                     " + requestPrincipal.getCommonName());
                sb.append("\n\trealm                  " + requestPrincipal.getRealmName());
                sb.append("\n\tprincipal              " + requestPrincipal.getPrincipal());
                sb.append("\n\tSAM type               " + requestPrincipal.getSamType());
                sb.append("\n\tKey type               " + requestPrincipal.getEncryptionKey().getKeyType());
                sb.append("\n\tKey version            " + requestPrincipal.getEncryptionKey().getKeyVersion());
                KerberosPrincipal ticketServerPrincipal = tgsContext.getTgt().getServerPrincipal();
                PrincipalStoreEntry ticketPrincipal = tgsContext.getTicketPrincipalEntry();
                sb.append("\n\tprincipal              " + ticketServerPrincipal);
                sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
                sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
                sb.append("\n\tprincipal              " + ticketPrincipal.getPrincipal());
                sb.append("\n\tSAM type               " + ticketPrincipal.getSamType());
                sb.append("\n\tKey type               " + ticketPrincipal.getEncryptionKey().getKeyType());
                sb.append("\n\tKey version            " + ticketPrincipal.getEncryptionKey().getKeyVersion());
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in context monitor", (Throwable)e);
            }
        }
        return false;
    }
}

