/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class SelectEncryptionType
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        KdcContext kdcContext = (KdcContext)context;
        KdcConfiguration config = kdcContext.getConfig();
        EncryptionType[] requestedTypes = kdcContext.getRequest().getEType();
        EncryptionType bestType = this.getBestEncryptionType(requestedTypes, config.getEncryptionTypes());
        if (bestType == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
        }
        return false;
    }

    protected EncryptionType getBestEncryptionType(EncryptionType[] requestedTypes, EncryptionType[] configuredTypes) {
        for (int ii = 0; ii < requestedTypes.length; ++ii) {
            for (int jj = 0; jj < configuredTypes.length; ++jj) {
                if (requestedTypes[ii] != configuredTypes[jj]) continue;
                return configuredTypes[jj];
            }
        }
        return null;
    }
}

