/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.net.InetAddress;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.directory.server.kerberos.shared.service.VerifyAuthHeader;
import org.apache.directory.server.protocol.shared.chain.Context;

public class VerifyTgtAuthHeader
extends VerifyAuthHeader {
    public boolean execute(Context context) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)context;
        ApplicationRequest authHeader = tgsContext.getAuthHeader();
        Ticket tgt = tgsContext.getTgt();
        EncryptionKey serverKey = tgsContext.getTicketPrincipalEntry().getEncryptionKey();
        long clockSkew = tgsContext.getConfig().getClockSkew();
        ReplayCache replayCache = tgsContext.getReplayCache();
        boolean emptyAddressesAllowed = tgsContext.getConfig().isEmptyAddressesAllowed();
        InetAddress clientAddress = tgsContext.getClientAddress();
        LockBox lockBox = tgsContext.getLockBox();
        Authenticator authenticator = this.verifyAuthHeader(authHeader, tgt, serverKey, clockSkew, replayCache, emptyAddressesAllowed, clientAddress, lockBox);
        tgsContext.setAuthenticator(authenticator);
        return false;
    }
}

