/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTicket
extends CommandBase {
    private static final Logger log = LoggerFactory.getLogger((Class)GenerateTicket.class);

    public boolean execute(Context context) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)context;
        KdcRequest request = authContext.getRequest();
        LockBox lockBox = authContext.getLockBox();
        KerberosPrincipal serverPrincipal = request.getServerPrincipal();
        EncryptionKey serverKey = authContext.getServerEntry().getEncryptionKey();
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        KdcConfiguration config = authContext.getConfig();
        EncryptionKey sessionKey = authContext.getSessionKey();
        if (request.getKdcOptions().get(1)) {
            newTicketBody.setFlag(1);
        }
        if (request.getKdcOptions().get(3)) {
            newTicketBody.setFlag(3);
        }
        if (request.getKdcOptions().get(5)) {
            newTicketBody.setFlag(5);
        }
        if (request.getKdcOptions().get(30) || request.getKdcOptions().get(31) || request.getKdcOptions().get(4) || request.getKdcOptions().get(2) || request.getKdcOptions().get(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(request.getClientPrincipal());
        newTicketBody.setTransitedEncoding(new TransitedEncoding());
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(now);
        if (request.getKdcOptions().get(6)) {
            if (!config.isPostdateAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(7);
            newTicketBody.setStartTime(request.getFrom());
        }
        long till = 0L;
        till = request.getTill().getTime() == 0L ? Long.MAX_VALUE : request.getTill().getTime();
        long endTime = Math.min(now.getTime() + config.getMaximumTicketLifetime(), till);
        KerberosTime kerberosEndTime = new KerberosTime(endTime);
        newTicketBody.setEndTime(kerberosEndTime);
        long tempRtime = 0L;
        if (request.getKdcOptions().get(27) && request.getTill().greaterThan(kerberosEndTime)) {
            request.getKdcOptions().set(8);
            tempRtime = request.getTill().getTime();
        }
        tempRtime = tempRtime == 0L ? Long.MAX_VALUE : request.getRtime().getTime();
        if (request.getKdcOptions().get(8)) {
            newTicketBody.setFlag(8);
            KerberosTime fromTime = request.getFrom();
            if (fromTime == null) {
                fromTime = new KerberosTime();
            }
            long renewTill = Math.min(fromTime.getTime() + config.getMaximumRenewableLifetime(), tempRtime);
            newTicketBody.setRenewTill(new KerberosTime(renewTill));
        }
        if (request.getAddresses() != null) {
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        EncryptedData encryptedData = lockBox.seal(serverKey, (Encodable)ticketPart);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        if (log.isDebugEnabled()) {
            log.debug("Ticket will be issued for access to " + serverPrincipal.toString() + ".");
        }
        authContext.setTicket(newTicket);
        return false;
    }
}

