/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

public class KdcConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 522567370475574165L;
    public static final String PRINCIPAL_KEY = "principal";
    public static final String REALM_KEY = "realm";
    public static final String ENCRYPTION_TYPES_KEY = "encryption.types";
    public static final String ALLOWABLE_CLOCKSKEW_KEY = "allowable.clockskew";
    public static final String EMPTY_ADDRESSES_ALLOWED_KEY = "empty.addresses.allowed";
    public static final String PA_ENC_TIMESTAMP_REQUIRED_KEY = "pa.enc.timestamp.required";
    public static final String TGS_MAXIMUM_TICKET_LIFETIME_KEY = "tgs.maximum.ticket.lifetime";
    public static final String TGS_MAXIMUM_RENEWABLE_LIFETIME_KEY = "tgs.maximum.renewable.lifetime";
    public static final String TGS_FORWARDABLE_ALLOWED_KEY = "tgs.forwardable.allowed";
    public static final String TGS_PROXIABLE_ALLOWED_KEY = "tgs.proxiable.allowed";
    public static final String TGS_POSTDATE_ALLOWED_KEY = "tgs.postdate.allowed";
    public static final String TGS_RENEWABLE_ALLOWED_KEY = "tgs.renewable.allowed";
    private static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final String DEFAULT_IP_PORT = "88";
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final String[] DEFAULT_ENCRYPTION_TYPES = new String[]{"des-cbc-md5"};
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    private static final boolean DEFAULT_PA_ENC_TIMESTAMP_REQUIRED = true;
    private static final int DEFAULT_TGS_MAXIMUM_TICKET_LIFETIME = 86400000;
    private static final int DEFAULT_TGS_MAXIMUM_RENEWABLE_LIFETIME = 604800000;
    private static final boolean DEFAULT_TGS_FORWARDABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_PROXIABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_POSTDATE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_RENEWABLE_ALLOWED = true;
    private static final String DEFAULT_PID = "org.apache.kerberos";
    private static final String DEFAULT_NAME = "Apache Kerberos Service";
    private static final String DEFAULT_PREFIX = "kdc.";
    private EncryptionType[] encryptionTypes;

    public KdcConfiguration() {
        this(KdcConfiguration.getDefaultConfig(), 1);
    }

    public KdcConfiguration(String instanceId) {
        this(KdcConfiguration.getDefaultConfig(), 1);
        this.setInstanceId(instanceId);
    }

    public KdcConfiguration(Map properties) {
        this(properties, 1);
    }

    public KdcConfiguration(Map properties, int strategy) {
        if (properties == null) {
            this.configuration = KdcConfiguration.getDefaultConfig();
        } else {
            this.loadProperties(DEFAULT_PREFIX, properties, strategy);
        }
        int port = this.getPort();
        if (port < 1 || port > 65535) {
            throw new ConfigurationException("Invalid value:  ipPort=" + port);
        }
        this.prepareEncryptionTypes();
    }

    public static Map getDefaultConfig() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("service.pid", DEFAULT_PID);
        defaults.put("ipPort", DEFAULT_IP_PORT);
        return defaults;
    }

    public boolean isDifferent(Dictionary config) {
        int port = this.getPort();
        return port != Integer.parseInt((String)config.get("ipPort"));
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getPrimaryRealm() {
        String key = REALM_KEY;
        if (this.configuration.containsKey(key)) {
            return this.get(key);
        }
        return DEFAULT_REALM;
    }

    public KerberosPrincipal getKdcPrincipal() {
        String key = PRINCIPAL_KEY;
        if (this.configuration.containsKey(key)) {
            return new KerberosPrincipal(this.get(key));
        }
        return new KerberosPrincipal(DEFAULT_PRINCIPAL);
    }

    public EncryptionType[] getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public Map getProperties() {
        this.configuration.put("java.naming.ldap.attributes.binary", "krb5Key");
        return this.configuration;
    }

    public long getClockSkew() {
        String key = ALLOWABLE_CLOCKSKEW_KEY;
        if (this.configuration.containsKey(key)) {
            return 60000L * Long.parseLong(this.get(key));
        }
        return 300000L;
    }

    public int getPort() {
        String key = "ipPort";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return Integer.parseInt(DEFAULT_IP_PORT);
    }

    public int getBufferSize() {
        String key = "buffer.size";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return 1024;
    }

    public boolean isPaEncTimestampRequired() {
        String key = PA_ENC_TIMESTAMP_REQUIRED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public long getMaximumTicketLifetime() {
        String key = TGS_MAXIMUM_TICKET_LIFETIME_KEY;
        if (this.configuration.containsKey(key)) {
            return 60000L * Long.parseLong(this.get(key));
        }
        return 86400000L;
    }

    public long getMaximumRenewableLifetime() {
        String key = TGS_MAXIMUM_RENEWABLE_LIFETIME_KEY;
        if (this.configuration.containsKey(key)) {
            return 60000L * Long.parseLong(this.get(key));
        }
        return 604800000L;
    }

    public boolean isEmptyAddressesAllowed() {
        String key = EMPTY_ADDRESSES_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public boolean isForwardableAllowed() {
        String key = TGS_FORWARDABLE_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public boolean isProxiableAllowed() {
        String key = TGS_PROXIABLE_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public boolean isPostdateAllowed() {
        String key = TGS_POSTDATE_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    public boolean isRenewableAllowed() {
        String key = TGS_RENEWABLE_ALLOWED_KEY;
        if (this.configuration.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return true;
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = null;
        String key = ENCRYPTION_TYPES_KEY;
        encryptionTypeStrings = this.configuration.containsKey(key) ? this.get(key).split("\\s") : DEFAULT_ENCRYPTION_TYPES;
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (int i = 0; i < encryptionTypeStrings.length; ++i) {
            String enc = encryptionTypeStrings[i];
            Iterator it = EncryptionType.VALUES.iterator();
            while (it.hasNext()) {
                EncryptionType type = (EncryptionType)it.next();
                if (!type.toString().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this.encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }
}

