/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import java.util.Map;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.checksum.Crc32Checksum;
import org.apache.directory.server.kerberos.shared.crypto.checksum.RsaMd4Checksum;
import org.apache.directory.server.kerberos.shared.crypto.checksum.RsaMd5Checksum;
import org.apache.directory.server.kerberos.shared.crypto.checksum.Sha1Checksum;
import org.apache.directory.server.kerberos.shared.replay.InMemoryReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class ConfigureAuthenticationChain
extends CommandBase {
    private static final ReplayCache replayCache = new InMemoryReplayCache();
    private static final LockBox lockBox = new LockBox();

    public boolean execute(Context context) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)context;
        authContext.setReplayCache(replayCache);
        authContext.setLockBox(lockBox);
        Map checksumEngines = authContext.getChecksumEngines();
        checksumEngines.put(ChecksumType.CRC32, new Crc32Checksum());
        checksumEngines.put(ChecksumType.RSA_MD4, new RsaMd4Checksum());
        checksumEngines.put(ChecksumType.RSA_MD5, new RsaMd5Checksum());
        checksumEngines.put(ChecksumType.SHA1, new Sha1Checksum());
        return false;
    }
}

