/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import java.util.Date;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class VerifyPolicy
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)context;
        PrincipalStoreEntry entry = authContext.getClientEntry();
        if (entry.isDisabled()) {
            throw new KerberosException(ErrorType.KDC_ERR_CLIENT_REVOKED);
        }
        if (entry.isLockedOut()) {
            throw new KerberosException(ErrorType.KDC_ERR_CLIENT_REVOKED);
        }
        if (entry.getExpiration().getTime() < new Date().getTime()) {
            throw new KerberosException(ErrorType.KDC_ERR_CLIENT_REVOKED);
        }
        return false;
    }
}

