/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.TicketGrantReply;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;

public class BuildReply
extends CommandBase {
    public boolean execute(Context context) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)context;
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Ticket newTicket = tgsContext.getNewTicket();
        EncryptionKey sessionKey = tgsContext.getSessionKey();
        TicketGrantReply reply = new TicketGrantReply();
        reply.setClientPrincipal(tgt.getClientPrincipal());
        reply.setTicket(newTicket);
        reply.setKey(sessionKey);
        reply.setNonce(request.getNonce());
        reply.setLastRequest(new LastRequest());
        reply.setFlags(newTicket.getFlags());
        reply.setClientAddresses(newTicket.getClientAddresses());
        reply.setAuthTime(newTicket.getAuthTime());
        reply.setStartTime(newTicket.getStartTime());
        reply.setEndTime(newTicket.getEndTime());
        reply.setServerPrincipal(newTicket.getServerPrincipal());
        if (newTicket.getFlag(8)) {
            reply.setRenewTill(newTicket.getRenewTill());
        }
        tgsContext.setReply((KerberosMessage)reply);
        return false;
    }
}

