/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorRequest
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorRequest.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        KdcContext kdcContext = (KdcContext)((Object)session.getAttribute(this.getContextKey()));
        KdcRequest request = kdcContext.getRequest();
        String clientAddress = kdcContext.getClientAddress().getHostAddress();
        if (log.isDebugEnabled()) {
            log.debug("Responding to authentication request:\n\trealm:                 " + request.getRealm() + "\n\tserverPrincipal:       " + request.getServerPrincipal() + "\n\tclientPrincipal:       " + request.getClientPrincipal() + "\n\tclientAddress:         " + clientAddress + "\n\thostAddresses:         " + request.getAddresses() + "\n\tencryptionType:        " + this.getEncryptionTypes(request) + "\n\tfrom krb time:         " + request.getFrom() + "\n\trealm krb time:        " + request.getRtime() + "\n\tkdcOptions:            " + request.getKdcOptions() + "\n\tmessageType:           " + request.getMessageType() + "\n\tnonce:                 " + request.getNonce() + "\n\tprotocolVersionNumber: " + request.getProtocolVersionNumber() + "\n\ttill:                  " + request.getTill());
        }
        next.execute(session, message);
    }

    public String getEncryptionTypes(KdcRequest request) {
        EncryptionType[] etypes = request.getEType();
        StringBuffer sb = new StringBuffer();
        for (int ii = 0; ii < etypes.length; ++ii) {
            sb.append(etypes[ii].toString());
            if (ii >= etypes.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

