/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class GenerateTicket
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)((Object)session.getAttribute(this.getContextKey()));
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Authenticator authenticator = tgsContext.getAuthenticator();
        LockBox lockBox = tgsContext.getLockBox();
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncryptionKey serverKey = tgsContext.getRequestPrincipalEntry().getEncryptionKey();
        KdcConfiguration config = tgsContext.getConfig();
        EncryptionKey sessionKey = tgsContext.getSessionKey();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        this.processFlags(config, request, tgt, newTicketBody);
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        if (request.getEncAuthorizationData() != null) {
            AuthorizationData authData = (AuthorizationData)lockBox.unseal(AuthorizationData.class, authenticator.getSubSessionKey(), request.getEncAuthorizationData());
            authData.add(tgt.getAuthorizationData());
            newTicketBody.setAuthorizationData(authData);
        }
        this.processTransited(newTicketBody, tgt);
        this.processTimes(config, request, newTicketBody, tgt);
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        if (request.getOption(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_SVC_UNAVAILABLE);
        }
        EncryptedData encryptedData = lockBox.seal(serverKey, (Encodable)ticketPart);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        tgsContext.setNewTicket(newTicket);
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }

    private void processFlags(KdcConfiguration config, KdcRequest request, Ticket tgt, EncTicketPartModifier newTicketBody) throws KerberosException {
        if (request.getOption(1)) {
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(1);
        }
        if (request.getOption(2)) {
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(2);
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        if (tgt.getFlag(2)) {
            newTicketBody.setFlag(2);
        }
        if (request.getOption(3)) {
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(3);
        }
        if (request.getOption(4)) {
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(4);
            newTicketBody.setClientAddresses(request.getAddresses());
        }
        if (request.getOption(5)) {
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(5);
        }
        if (request.getOption(6)) {
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(6);
            newTicketBody.setFlag(7);
            if (!config.isPostdateAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setStartTime(request.getFrom());
        }
        if (request.getOption(31)) {
            if (!tgt.getFlag(7)) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (tgt.getStartTime().greaterThan(new KerberosTime())) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.clearFlag(7);
        }
        if (request.getOption(0) || request.getOption(27)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
    }

    private void processTimes(KdcConfiguration config, KdcRequest request, EncTicketPartModifier newTicketBody, Ticket tgt) throws KerberosException {
        ArrayList<KerberosTime> minimizer;
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(tgt.getAuthTime());
        KerberosTime renewalTime = null;
        if (request.getOption(30)) {
            if (!tgt.getFlag(8)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (tgt.getRenewTill().greaterThan(now)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.setStartTime(now);
            long oldLife = tgt.getEndTime().getTime() - tgt.getStartTime().getTime();
            newTicketBody.setEndTime(new KerberosTime(Math.min(tgt.getRenewTill().getTime(), now.getTime() + oldLife)));
        } else {
            newTicketBody.setStartTime(now);
            KerberosTime till = request.getTill().isZero() ? KerberosTime.INFINITY : request.getTill();
            minimizer = new ArrayList<KerberosTime>();
            minimizer.add(till);
            minimizer.add(new KerberosTime(now.getTime() + config.getMaximumTicketLifetime()));
            minimizer.add(tgt.getEndTime());
            KerberosTime minTime = (KerberosTime)Collections.min(minimizer);
            newTicketBody.setEndTime(minTime);
            if (request.getOption(27) && minTime.lessThan(request.getTill()) && tgt.getFlag(8)) {
                request.setOption(8);
                long rtime = Math.min(request.getTill().getTime(), tgt.getRenewTill().getTime());
                renewalTime = new KerberosTime(rtime);
            }
        }
        if (renewalTime == null) {
            renewalTime = request.getRtime();
        }
        KerberosTime rtime = renewalTime != null && renewalTime.isZero() ? KerberosTime.INFINITY : renewalTime;
        if (request.getOption(8) && tgt.getFlag(8)) {
            newTicketBody.setFlag(8);
            minimizer = new ArrayList();
            if (rtime != null) {
                minimizer.add(rtime);
            }
            minimizer.add(new KerberosTime(now.getTime() + config.getMaximumRenewableLifetime()));
            minimizer.add(tgt.getRenewTill());
            newTicketBody.setRenewTill((KerberosTime)Collections.min(minimizer));
        }
    }

    private void processTransited(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }

    protected void echoTicket(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setAuthorizationData(tgt.getAuthorizationData());
        newTicketBody.setAuthTime(tgt.getAuthTime());
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        newTicketBody.setEndTime(tgt.getEndTime());
        newTicketBody.setFlags(tgt.getFlags());
        newTicketBody.setRenewTill(tgt.getRenewTill());
        newTicketBody.setSessionKey(tgt.getSessionKey());
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }
}

