/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.TicketGrantReply;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.service.LockBox;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class SealReply
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        TicketGrantReply reply = (TicketGrantReply)tgsContext.getReply();
        Ticket tgt = tgsContext.getTgt();
        LockBox lockBox = tgsContext.getLockBox();
        Authenticator authenticator = tgsContext.getAuthenticator();
        EncryptedData encryptedData = authenticator.getSubSessionKey() != null ? lockBox.seal(authenticator.getSubSessionKey(), (Encodable)reply) : lockBox.seal(tgt.getSessionKey(), (Encodable)reply);
        reply.setEncPart(encryptedData);
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

