/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationServiceChain;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingServiceChain;
import org.apache.directory.server.kerberos.protocol.KerberosProtocolCodecFactory;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(KerberosProtocolHandler.class);
    private KdcConfiguration config;
    private PrincipalStore store;
    private IoHandlerCommand authService;
    private IoHandlerCommand tgsService;
    private String contextKey = "context";

    public KerberosProtocolHandler(KdcConfiguration config, PrincipalStore store) {
        this.config = config;
        this.store = store;
        this.authService = new AuthenticationServiceChain();
        this.tgsService = new TicketGrantingServiceChain();
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " CREATED");
        }
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)KerberosProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " OPENED");
        }
    }

    public void sessionClosed(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " CLOSED");
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " IDLE(" + status + ")");
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " RCVD: " + message);
        }
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        KdcRequest request = (KdcRequest)message;
        int messageType = request.getMessageType().getOrdinal();
        try {
            switch (messageType) {
                case 10: {
                    AuthenticationContext authContext = new AuthenticationContext();
                    authContext.setConfig(this.config);
                    authContext.setStore(this.store);
                    authContext.setClientAddress(clientAddress);
                    authContext.setRequest(request);
                    session.setAttribute(this.getContextKey(), (Object)authContext);
                    this.authService.execute(null, session, message);
                    session.write((Object)authContext.getReply());
                    break;
                }
                case 12: {
                    TicketGrantingContext tgsContext = new TicketGrantingContext();
                    tgsContext.setConfig(this.config);
                    tgsContext.setStore(this.store);
                    tgsContext.setClientAddress(clientAddress);
                    tgsContext.setRequest(request);
                    session.setAttribute(this.getContextKey(), (Object)tgsContext);
                    this.tgsService.execute(null, session, message);
                    session.write((Object)tgsContext.getReply());
                    break;
                }
                case 11: 
                case 13: {
                    log.error("Kerberos error:  " + ErrorType.KRB_AP_ERR_BADDIRECTION.getMessage());
                }
                default: {
                    log.error("Kerberos error:  " + ErrorType.KRB_AP_ERR_MSG_TYPE.getMessage());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            KerberosException ke = (KerberosException)e;
            session.write((Object)this.getErrorMessage(this.config.getKdcPrincipal(), ke));
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug(session.getRemoteAddress() + " SENT: " + message);
        }
    }

    public ErrorMessage getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        ErrorMessageModifier modifier = new ErrorMessageModifier();
        KerberosTime now = new KerberosTime();
        modifier.setErrorCode(exception.getErrorCode());
        modifier.setExplanatoryText(exception.getMessage());
        modifier.setServerPrincipal(principal);
        modifier.setServerTime(now);
        modifier.setServerMicroSecond(0);
        modifier.setExplanatoryData(exception.getExplanatoryData());
        return modifier.getErrorMessage();
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

