/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.protocol.KerberosProtocolHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.store.DirectoryPrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KdcServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 522567370475574165L;
    private static final int DEFAULT_IP_PORT = 88;
    private static final String DEFAULT_PID = "org.apache.directory.server.kerberos";
    private static final String DEFAULT_NAME = "ApacheDS Kerberos Service";
    private static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final String[] DEFAULT_ENCRYPTION_TYPES = new String[]{"des-cbc-md5"};
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    private static final boolean DEFAULT_PA_ENC_TIMESTAMP_REQUIRED = true;
    private static final int DEFAULT_TGS_MAXIMUM_TICKET_LIFETIME = 86400000;
    private static final int DEFAULT_TGS_MAXIMUM_RENEWABLE_LIFETIME = 604800000;
    private static final boolean DEFAULT_TGS_FORWARDABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_PROXIABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_POSTDATED_ALLOWED = true;
    private static final boolean DEFAULT_TGS_RENEWABLE_ALLOWED = true;
    private static final boolean DEFAULT_VERIFY_BODY_CHECKSUM = true;
    private Set<EncryptionType> encryptionTypes;
    private String primaryRealm = "EXAMPLE.COM";
    private String servicePrincipal = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private long allowableClockSkew = 300000L;
    private boolean isPaEncTimestampRequired = true;
    private long maximumTicketLifetime = 86400000L;
    private long maximumRenewableLifetime = 604800000L;
    private boolean isEmptyAddressesAllowed = true;
    private boolean isForwardableAllowed = true;
    private boolean isProxiableAllowed = true;
    private boolean isPostdatedAllowed = true;
    private boolean isRenewableAllowed = true;
    private boolean isBodyChecksumVerified = true;

    public KdcServer() {
        super.setServiceName(DEFAULT_NAME);
        super.setIpPort(88);
        super.setServiceId(DEFAULT_PID);
        super.setSearchBaseDn("ou=users,dc=example,dc=com");
        this.prepareEncryptionTypes();
    }

    public long getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public boolean isEmptyAddressesAllowed() {
        return this.isEmptyAddressesAllowed;
    }

    public boolean isForwardableAllowed() {
        return this.isForwardableAllowed;
    }

    public boolean isPostdatedAllowed() {
        return this.isPostdatedAllowed;
    }

    public boolean isProxiableAllowed() {
        return this.isProxiableAllowed;
    }

    public boolean isRenewableAllowed() {
        return this.isRenewableAllowed;
    }

    public long getMaximumRenewableLifetime() {
        return this.maximumRenewableLifetime;
    }

    public long getMaximumTicketLifetime() {
        return this.maximumTicketLifetime;
    }

    public void setAllowableClockSkew(long allowableClockSkew) {
        this.allowableClockSkew = allowableClockSkew;
    }

    public void setEncryptionTypes(EncryptionType[] encryptionTypes) {
        if (encryptionTypes != null) {
            this.encryptionTypes.clear();
            for (EncryptionType encryptionType : encryptionTypes) {
                this.encryptionTypes.add(encryptionType);
            }
        }
    }

    public void setEncryptionTypes(Set<EncryptionType> encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public void setEmptyAddressesAllowed(boolean isEmptyAddressesAllowed) {
        this.isEmptyAddressesAllowed = isEmptyAddressesAllowed;
    }

    public void setForwardableAllowed(boolean isForwardableAllowed) {
        this.isForwardableAllowed = isForwardableAllowed;
    }

    public void setPaEncTimestampRequired(boolean isPaEncTimestampRequired) {
        this.isPaEncTimestampRequired = isPaEncTimestampRequired;
    }

    public void setPostdatedAllowed(boolean isPostdatedAllowed) {
        this.isPostdatedAllowed = isPostdatedAllowed;
    }

    public void setProxiableAllowed(boolean isProxiableAllowed) {
        this.isProxiableAllowed = isProxiableAllowed;
    }

    public void setRenewableAllowed(boolean isRenewableAllowed) {
        this.isRenewableAllowed = isRenewableAllowed;
    }

    public void setKdcPrincipal(String kdcPrincipal) {
        this.servicePrincipal = kdcPrincipal;
    }

    public void setMaximumRenewableLifetime(long maximumRenewableLifetime) {
        this.maximumRenewableLifetime = maximumRenewableLifetime;
    }

    public void setMaximumTicketLifetime(long maximumTicketLifetime) {
        this.maximumTicketLifetime = maximumTicketLifetime;
    }

    public void setPrimaryRealm(String primaryRealm) {
        this.primaryRealm = primaryRealm;
    }

    public String getPrimaryRealm() {
        return this.primaryRealm;
    }

    public KerberosPrincipal getServicePrincipal() {
        return new KerberosPrincipal(this.servicePrincipal);
    }

    public Set<EncryptionType> getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public boolean isPaEncTimestampRequired() {
        return this.isPaEncTimestampRequired;
    }

    public boolean isBodyChecksumVerified() {
        return this.isBodyChecksumVerified;
    }

    public void setBodyChecksumVerified(boolean isBodyChecksumVerified) {
        this.isBodyChecksumVerified = isBodyChecksumVerified;
    }

    public void start() throws IOException {
        DirectoryPrincipalStore store = new DirectoryPrincipalStore(this.getDirectoryService());
        if (this.getDatagramAcceptor() != null) {
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            this.getDatagramAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new KerberosProtocolHandler(this, (PrincipalStore)store), (IoServiceConfig)udpConfig);
        }
        if (this.getSocketAcceptor() != null) {
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            this.getSocketAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new KerberosProtocolHandler(this, (PrincipalStore)store), (IoServiceConfig)tcpConfig);
        }
    }

    public void stop() {
        if (this.getDatagramAcceptor() != null) {
            this.getDatagramAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
        if (this.getSocketAcceptor() != null) {
            this.getSocketAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = DEFAULT_ENCRYPTION_TYPES;
        this.encryptionTypes = new HashSet<EncryptionType>();
        for (String enc : encryptionTypeStrings) {
            for (EncryptionType type : EncryptionType.getEncryptionTypes()) {
                if (!type.getName().equalsIgnoreCase(enc)) continue;
                this.encryptionTypes.add(type);
            }
        }
    }
}

