/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.KerberosUtils;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumHandler;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.ApplicationRequestDecoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.TicketGrantReply;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.Checksum;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.flags.KerberosFlag;
import org.apache.directory.server.kerberos.shared.messages.value.flags.TicketFlag;
import org.apache.directory.server.kerberos.shared.messages.value.types.PaDataType;
import org.apache.directory.server.kerberos.shared.replay.InMemoryReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketGrantingService {
    private static final Logger LOG = LoggerFactory.getLogger(TicketGrantingService.class);
    private static final InMemoryReplayCache replayCache = new InMemoryReplayCache();
    private static final CipherTextHandler cipherTextHandler = new CipherTextHandler();
    private static final String SERVICE_NAME = "Ticket-Granting Service (TGS)";
    private static final ChecksumHandler checksumHandler = new ChecksumHandler();

    public static void execute(TicketGrantingContext tgsContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            TicketGrantingService.monitorRequest(tgsContext);
        }
        TicketGrantingService.configureTicketGranting(tgsContext);
        TicketGrantingService.selectEncryptionType(tgsContext);
        TicketGrantingService.getAuthHeader(tgsContext);
        TicketGrantingService.verifyTgt(tgsContext);
        TicketGrantingService.getTicketPrincipalEntry(tgsContext);
        TicketGrantingService.verifyTgtAuthHeader(tgsContext);
        TicketGrantingService.verifyBodyChecksum(tgsContext);
        TicketGrantingService.getRequestPrincipalEntry(tgsContext);
        TicketGrantingService.generateTicket(tgsContext);
        TicketGrantingService.buildReply(tgsContext);
        if (LOG.isDebugEnabled()) {
            TicketGrantingService.monitorContext(tgsContext);
            TicketGrantingService.monitorReply(tgsContext);
        }
        TicketGrantingService.sealReply(tgsContext);
    }

    private static void configureTicketGranting(TicketGrantingContext tgsContext) throws KerberosException {
        KdcServer config = tgsContext.getConfig();
        long clockSkew = config.getAllowableClockSkew();
        replayCache.setClockSkew(clockSkew);
        tgsContext.setReplayCache((ReplayCache)replayCache);
        tgsContext.setCipherTextHandler(cipherTextHandler);
        if (tgsContext.getRequest().getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KDC_ERR_BAD_PVNO);
        }
    }

    private static void monitorRequest(KdcContext kdcContext) throws Exception {
        KdcRequest request = kdcContext.getRequest();
        try {
            String clientAddress = kdcContext.getClientAddress().getHostAddress();
            StringBuffer sb = new StringBuffer();
            sb.append("Received Ticket-Granting Service (TGS) request:");
            sb.append("\n\tmessageType:           " + request.getMessageType());
            sb.append("\n\tprotocolVersionNumber: " + request.getProtocolVersionNumber());
            sb.append("\n\tclientAddress:         " + clientAddress);
            sb.append("\n\tnonce:                 " + request.getNonce());
            sb.append("\n\tkdcOptions:            " + request.getKdcOptions());
            sb.append("\n\tclientPrincipal:       " + request.getClientPrincipal());
            sb.append("\n\tserverPrincipal:       " + request.getServerPrincipal());
            sb.append("\n\tencryptionType:        " + KerberosUtils.getEncryptionTypesString((Set)request.getEType()));
            sb.append("\n\trealm:                 " + request.getRealm());
            sb.append("\n\tfrom time:             " + request.getFrom());
            sb.append("\n\ttill time:             " + request.getTill());
            sb.append("\n\trenew-till time:       " + request.getRtime());
            sb.append("\n\thostAddresses:         " + request.getAddresses());
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err((String)I18n.ERR_153, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static void selectEncryptionType(TicketGrantingContext tgsContext) throws Exception {
        TicketGrantingContext kdcContext = tgsContext;
        KdcServer config = kdcContext.getConfig();
        Set requestedTypes = kdcContext.getRequest().getEType();
        EncryptionType bestType = KerberosUtils.getBestEncryptionType((Set)requestedTypes, config.getEncryptionTypes());
        LOG.debug("Session will use encryption type {}.", (Object)bestType);
        if (bestType == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
        }
        kdcContext.setEncryptionType(bestType);
    }

    private static void getAuthHeader(TicketGrantingContext tgsContext) throws Exception {
        KdcRequest request = tgsContext.getRequest();
        PaData[] preAuthData = request.getPreAuthData();
        if (preAuthData == null || preAuthData.length < 1) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        byte[] undecodedAuthHeader = null;
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            if (preAuthData[ii].getPaDataType() != PaDataType.PA_TGS_REQ) continue;
            undecodedAuthHeader = preAuthData[ii].getPaDataValue();
        }
        if (undecodedAuthHeader == null) {
            throw new KerberosException(ErrorType.KDC_ERR_PADATA_TYPE_NOSUPP);
        }
        ApplicationRequestDecoder decoder = new ApplicationRequestDecoder();
        ApplicationRequest authHeader = decoder.decode(undecodedAuthHeader);
        Ticket tgt = authHeader.getTicket();
        tgsContext.setAuthHeader(authHeader);
        tgsContext.setTgt(tgt);
    }

    public static void verifyTgt(TicketGrantingContext tgsContext) throws KerberosException {
        KdcServer config = tgsContext.getConfig();
        Ticket tgt = tgsContext.getTgt();
        if (!tgt.getRealm().equals(config.getPrimaryRealm())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
        String tgtServerName = tgt.getServerPrincipal().getName();
        String requestServerName = tgsContext.getRequest().getServerPrincipal().getName();
        if (!tgtServerName.equals(config.getServicePrincipal().getName()) && !tgtServerName.equals(requestServerName)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
    }

    private static void getTicketPrincipalEntry(TicketGrantingContext tgsContext) throws KerberosException {
        KerberosPrincipal principal = tgsContext.getTgt().getServerPrincipal();
        PrincipalStore store = tgsContext.getStore();
        PrincipalStoreEntry entry = KerberosUtils.getEntry((KerberosPrincipal)principal, (PrincipalStore)store, (ErrorType)ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN);
        tgsContext.setTicketPrincipalEntry(entry);
    }

    private static void verifyTgtAuthHeader(TicketGrantingContext tgsContext) throws KerberosException {
        ApplicationRequest authHeader = tgsContext.getAuthHeader();
        Ticket tgt = tgsContext.getTgt();
        boolean isValidate = tgsContext.getRequest().getKdcOptions().get(31);
        EncryptionType encryptionType = tgt.getEncPart().getEType();
        EncryptionKey serverKey = (EncryptionKey)tgsContext.getTicketPrincipalEntry().getKeyMap().get(encryptionType);
        long clockSkew = tgsContext.getConfig().getAllowableClockSkew();
        ReplayCache replayCache = tgsContext.getReplayCache();
        boolean emptyAddressesAllowed = tgsContext.getConfig().isEmptyAddressesAllowed();
        InetAddress clientAddress = tgsContext.getClientAddress();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        Authenticator authenticator = KerberosUtils.verifyAuthHeader((ApplicationRequest)authHeader, (Ticket)tgt, (EncryptionKey)serverKey, (long)clockSkew, (ReplayCache)replayCache, (boolean)emptyAddressesAllowed, (InetAddress)clientAddress, (CipherTextHandler)cipherTextHandler, (KeyUsage)KeyUsage.NUMBER7, (boolean)isValidate);
        tgsContext.setAuthenticator(authenticator);
    }

    private static void verifyBodyChecksum(TicketGrantingContext tgsContext) throws KerberosException {
        KdcServer config = tgsContext.getConfig();
        if (config.isBodyChecksumVerified()) {
            byte[] bodyBytes = tgsContext.getRequest().getBodyBytes();
            Checksum authenticatorChecksum = tgsContext.getAuthenticator().getChecksum();
            if (authenticatorChecksum == null || authenticatorChecksum.getChecksumType() == null || authenticatorChecksum.getChecksumValue() == null || bodyBytes == null) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
            }
            LOG.debug("Verifying body checksum type '{}'.", (Object)authenticatorChecksum.getChecksumType());
            checksumHandler.verifyChecksum(authenticatorChecksum, bodyBytes, null, KeyUsage.NUMBER8);
        }
    }

    public static void getRequestPrincipalEntry(TicketGrantingContext tgsContext) throws KerberosException {
        KerberosPrincipal principal = tgsContext.getRequest().getServerPrincipal();
        PrincipalStore store = tgsContext.getStore();
        PrincipalStoreEntry entry = KerberosUtils.getEntry((KerberosPrincipal)principal, (PrincipalStore)store, (ErrorType)ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN);
        tgsContext.setRequestPrincipalEntry(entry);
    }

    private static void generateTicket(TicketGrantingContext tgsContext) throws KerberosException {
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Authenticator authenticator = tgsContext.getAuthenticator();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncryptionType encryptionType = tgsContext.getEncryptionType();
        EncryptionKey serverKey = (EncryptionKey)tgsContext.getRequestPrincipalEntry().getKeyMap().get(encryptionType);
        KdcServer config = tgsContext.getConfig();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        newTicketBody.setClientAddresses(tgt.getEncTicketPart().getClientAddresses());
        TicketGrantingService.processFlags(config, request, tgt, newTicketBody);
        EncryptionKey sessionKey = RandomKeyFactory.getRandomKey((EncryptionType)tgsContext.getEncryptionType());
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(tgt.getEncTicketPart().getClientPrincipal());
        if (request.getEncAuthorizationData() != null) {
            AuthorizationData authData = (AuthorizationData)cipherTextHandler.unseal(AuthorizationData.class, authenticator.getSubSessionKey(), request.getEncAuthorizationData(), KeyUsage.NUMBER4);
            authData.add(tgt.getEncTicketPart().getAuthorizationData());
            newTicketBody.setAuthorizationData(authData);
        }
        TicketGrantingService.processTransited(newTicketBody, tgt);
        TicketGrantingService.processTimes(config, request, newTicketBody, tgt);
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        if (request.getOption(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        EncryptedData encryptedData = cipherTextHandler.seal(serverKey, (Encodable)ticketPart, KeyUsage.NUMBER2);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        tgsContext.setNewTicket(newTicket);
    }

    private static void buildReply(TicketGrantingContext tgsContext) throws KerberosException {
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Ticket newTicket = tgsContext.getNewTicket();
        TicketGrantReply reply = new TicketGrantReply();
        reply.setClientPrincipal(tgt.getEncTicketPart().getClientPrincipal());
        reply.setTicket(newTicket);
        reply.setKey(newTicket.getEncTicketPart().getSessionKey());
        reply.setNonce(request.getNonce());
        reply.setLastRequest(new LastRequest());
        reply.setFlags(newTicket.getEncTicketPart().getFlags());
        reply.setClientAddresses(newTicket.getEncTicketPart().getClientAddresses());
        reply.setAuthTime(newTicket.getEncTicketPart().getAuthTime());
        reply.setStartTime(newTicket.getEncTicketPart().getStartTime());
        reply.setEndTime(newTicket.getEncTicketPart().getEndTime());
        reply.setServerPrincipal(newTicket.getServerPrincipal());
        if (newTicket.getEncTicketPart().getFlags().isRenewable()) {
            reply.setRenewTill(newTicket.getEncTicketPart().getRenewTill());
        }
        tgsContext.setReply((KerberosMessage)reply);
    }

    private static void sealReply(TicketGrantingContext tgsContext) throws KerberosException {
        TicketGrantReply reply = (TicketGrantReply)tgsContext.getReply();
        Ticket tgt = tgsContext.getTgt();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        Authenticator authenticator = tgsContext.getAuthenticator();
        EncryptedData encryptedData = authenticator.getSubSessionKey() != null ? cipherTextHandler.seal(authenticator.getSubSessionKey(), (Encodable)reply, KeyUsage.NUMBER9) : cipherTextHandler.seal(tgt.getEncTicketPart().getSessionKey(), (Encodable)reply, KeyUsage.NUMBER8);
        reply.setEncPart(encryptedData);
    }

    private static void monitorContext(TicketGrantingContext tgsContext) {
        try {
            Ticket tgt = tgsContext.getTgt();
            long clockSkew = tgsContext.getConfig().getAllowableClockSkew();
            ChecksumType checksumType = tgsContext.getAuthenticator().getChecksum().getChecksumType();
            InetAddress clientAddress = tgsContext.getClientAddress();
            HostAddresses clientAddresses = tgt.getEncTicketPart().getClientAddresses();
            boolean caddrContainsSender = false;
            if (tgt.getEncTicketPart().getClientAddresses() != null) {
                caddrContainsSender = tgt.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Monitoring Ticket-Granting Service (TGS) context:");
            sb.append("\n\tclockSkew              " + clockSkew);
            sb.append("\n\tchecksumType           " + checksumType);
            sb.append("\n\tclientAddress          " + clientAddress);
            sb.append("\n\tclientAddresses        " + clientAddresses);
            sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
            KerberosPrincipal requestServerPrincipal = tgsContext.getRequest().getServerPrincipal();
            PrincipalStoreEntry requestPrincipal = tgsContext.getRequestPrincipalEntry();
            sb.append("\n\tprincipal              " + requestServerPrincipal);
            sb.append("\n\tcn                     " + requestPrincipal.getCommonName());
            sb.append("\n\trealm                  " + requestPrincipal.getRealmName());
            sb.append("\n\tprincipal              " + requestPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + requestPrincipal.getSamType());
            KerberosPrincipal ticketServerPrincipal = tgsContext.getTgt().getServerPrincipal();
            PrincipalStoreEntry ticketPrincipal = tgsContext.getTicketPrincipalEntry();
            sb.append("\n\tprincipal              " + ticketServerPrincipal);
            sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
            sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
            sb.append("\n\tprincipal              " + ticketPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + ticketPrincipal.getSamType());
            EncryptionType encryptionType = tgsContext.getTgt().getEncPart().getEType();
            int keyVersion = ((EncryptionKey)ticketPrincipal.getKeyMap().get(encryptionType)).getKeyVersion();
            sb.append("\n\tTicket key type        " + encryptionType);
            sb.append("\n\tService key version    " + keyVersion);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err((String)I18n.ERR_154, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static void monitorReply(KdcContext kdcContext) {
        KerberosMessage reply = kdcContext.getReply();
        if (reply instanceof KdcReply) {
            KdcReply success = (KdcReply)reply;
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("Responding with Ticket-Granting Service (TGS) reply:");
                sb.append("\n\tmessageType:           " + success.getMessageType());
                sb.append("\n\tprotocolVersionNumber: " + success.getProtocolVersionNumber());
                sb.append("\n\tnonce:                 " + success.getNonce());
                sb.append("\n\tclientPrincipal:       " + success.getClientPrincipal());
                sb.append("\n\tclient realm:          " + success.getClientRealm());
                sb.append("\n\tserverPrincipal:       " + success.getServerPrincipal());
                sb.append("\n\tserver realm:          " + success.getServerRealm());
                sb.append("\n\tauth time:             " + success.getAuthTime());
                sb.append("\n\tstart time:            " + success.getStartTime());
                sb.append("\n\tend time:              " + success.getEndTime());
                sb.append("\n\trenew-till time:       " + success.getRenewTill());
                sb.append("\n\thostAddresses:         " + success.getClientAddresses());
                LOG.debug(sb.toString());
            }
            catch (Exception e) {
                LOG.error(I18n.err((String)I18n.ERR_155, (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private static void processFlags(KdcServer config, KdcRequest request, Ticket tgt, EncTicketPartModifier newTicketBody) throws KerberosException {
        if (tgt.getEncTicketPart().getFlags().isPreAuth()) {
            newTicketBody.setFlag((KerberosFlag)TicketFlag.PRE_AUTHENT);
        }
        if (request.getOption(1)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isForwardable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.FORWARDABLE);
        }
        if (request.getOption(2)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isForwardable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getAddresses() != null && request.getAddresses().getAddresses() != null && request.getAddresses().getAddresses().length > 0) {
                newTicketBody.setClientAddresses(request.getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.FORWARDED);
        }
        if (tgt.getEncTicketPart().getFlags().isForwarded()) {
            newTicketBody.setFlag((KerberosFlag)TicketFlag.FORWARDED);
        }
        if (request.getOption(3)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isProxiable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.PROXIABLE);
        }
        if (request.getOption(4)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isProxiable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getAddresses() != null && request.getAddresses().getAddresses() != null && request.getAddresses().getAddresses().length > 0) {
                newTicketBody.setClientAddresses(request.getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.PROXY);
        }
        if (request.getOption(5)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isMayPosdate()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.MAY_POSTDATE);
        }
        if (request.getOption(6)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isMayPosdate()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.POSTDATED);
            newTicketBody.setFlag((KerberosFlag)TicketFlag.INVALID);
            newTicketBody.setStartTime(request.getFrom());
        }
        if (request.getOption(31)) {
            KerberosTime startTime;
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isInvalid()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            KerberosTime kerberosTime = startTime = tgt.getEncTicketPart().getStartTime() != null ? tgt.getEncTicketPart().getStartTime() : tgt.getEncTicketPart().getAuthTime();
            if (startTime.greaterThan(new KerberosTime())) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
            }
            TicketGrantingService.echoTicket(newTicketBody, tgt);
            newTicketBody.clearFlag((KerberosFlag)TicketFlag.INVALID);
        }
        if (request.getOption(0)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
    }

    private static void processTimes(KdcServer config, KdcRequest request, EncTicketPartModifier newTicketBody, Ticket tgt) throws KerberosException {
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(tgt.getEncTicketPart().getAuthTime());
        KerberosTime startTime = request.getFrom();
        if (startTime == null || startTime.lessThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) && !request.getOption(6)) {
            startTime = now;
        }
        if (!(startTime == null || !startTime.greaterThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) || request.getOption(6) && tgt.getEncTicketPart().getFlags().isMayPosdate())) {
            throw new KerberosException(ErrorType.KDC_ERR_CANNOT_POSTDATE);
        }
        KerberosTime renewalTime = null;
        KerberosTime kerberosEndTime = null;
        if (request.getOption(30)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getEncTicketPart().getFlags().isRenewable()) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (tgt.getEncTicketPart().getRenewTill().lessThan(now)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
            }
            TicketGrantingService.echoTicket(newTicketBody, tgt);
            newTicketBody.setStartTime(now);
            KerberosTime tgtStartTime = tgt.getEncTicketPart().getStartTime() != null ? tgt.getEncTicketPart().getStartTime() : tgt.getEncTicketPart().getAuthTime();
            long oldLife = tgt.getEncTicketPart().getEndTime().getTime() - tgtStartTime.getTime();
            kerberosEndTime = new KerberosTime(Math.min(tgt.getEncTicketPart().getRenewTill().getTime(), now.getTime() + oldLife));
            newTicketBody.setEndTime(kerberosEndTime);
        } else {
            if (newTicketBody.getEncTicketPart().getStartTime() == null) {
                newTicketBody.setStartTime(now);
            }
            KerberosTime till = request.getTill().isZero() ? KerberosTime.INFINITY : request.getTill();
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            minimizer.add(till);
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumTicketLifetime()));
            minimizer.add(tgt.getEncTicketPart().getEndTime());
            kerberosEndTime = (KerberosTime)Collections.min(minimizer);
            newTicketBody.setEndTime(kerberosEndTime);
            if (request.getOption(27) && kerberosEndTime.lessThan(request.getTill()) && tgt.getEncTicketPart().getFlags().isRenewable()) {
                if (!config.isRenewableAllowed()) {
                    throw new KerberosException(ErrorType.KDC_ERR_POLICY);
                }
                request.setOption(8);
                long rtime = Math.min(request.getTill().getTime(), tgt.getEncTicketPart().getRenewTill().getTime());
                renewalTime = new KerberosTime(rtime);
            }
        }
        if (renewalTime == null) {
            renewalTime = request.getRtime();
        }
        KerberosTime rtime = renewalTime != null && renewalTime.isZero() ? KerberosTime.INFINITY : renewalTime;
        if (request.getOption(8) && tgt.getEncTicketPart().getFlags().isRenewable()) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag((KerberosFlag)TicketFlag.RENEWABLE);
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            if (rtime != null) {
                minimizer.add(rtime);
            }
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumRenewableLifetime()));
            minimizer.add(tgt.getEncTicketPart().getRenewTill());
            newTicketBody.setRenewTill((KerberosTime)Collections.min(minimizer));
        }
        if (kerberosEndTime.lessThan(startTime)) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
        long ticketLifeTime = Math.abs(startTime.getTime() - kerberosEndTime.getTime());
        if (ticketLifeTime < config.getAllowableClockSkew()) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
    }

    private static void processTransited(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setTransitedEncoding(tgt.getEncTicketPart().getTransitedEncoding());
    }

    private static void echoTicket(EncTicketPartModifier newTicketBody, Ticket tgt) {
        EncTicketPart encTicketpart = tgt.getEncTicketPart();
        newTicketBody.setAuthorizationData(encTicketpart.getAuthorizationData());
        newTicketBody.setAuthTime(encTicketpart.getAuthTime());
        newTicketBody.setClientAddresses(encTicketpart.getClientAddresses());
        newTicketBody.setClientPrincipal(encTicketpart.getClientPrincipal());
        newTicketBody.setEndTime(encTicketpart.getEndTime());
        newTicketBody.setFlags(encTicketpart.getFlags());
        newTicketBody.setRenewTill(encTicketpart.getRenewTill());
        newTicketBody.setSessionKey(encTicketpart.getSessionKey());
        newTicketBody.setTransitedEncoding(encTicketpart.getTransitedEncoding());
    }
}

