/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationService;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.KdcReq;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(KerberosProtocolHandler.class);
    private KdcServer config;
    private PrincipalStore store;
    private static final String CONTEXT_KEY = "context";

    public KerberosProtocolHandler(KdcServer config, PrincipalStore store) {
        this.config = config;
        this.store = store;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
    }

    public void sessionOpened(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug("{} OPENED", (Object)session.getRemoteAddress());
        }
    }

    public void sessionClosed(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug("{} CLOSED", (Object)session.getRemoteAddress());
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (log.isDebugEnabled()) {
            log.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} RCVD:  {}", (Object)session.getRemoteAddress(), message);
        }
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        if (!(message instanceof KdcReq)) {
            log.error(I18n.err((I18n)I18n.ERR_152, (Object[])new Object[]{ErrorType.KRB_AP_ERR_BADDIRECTION}));
            session.write((Object)this.getErrorMessage(this.config.getServicePrincipal(), new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION)));
            return;
        }
        KdcReq request = (KdcReq)message;
        KerberosMessageType messageType = request.getMessageType();
        try {
            switch (messageType) {
                case AS_REQ: {
                    AuthenticationContext authContext = new AuthenticationContext();
                    authContext.setConfig(this.config);
                    authContext.setStore(this.store);
                    authContext.setClientAddress(clientAddress);
                    authContext.setRequest(request);
                    session.setAttribute((Object)CONTEXT_KEY, (Object)authContext);
                    AuthenticationService.execute(authContext);
                    session.write((Object)authContext.getReply());
                    break;
                }
                case TGS_REQ: {
                    TicketGrantingContext tgsContext = new TicketGrantingContext();
                    tgsContext.setConfig(this.config);
                    tgsContext.setStore(this.store);
                    tgsContext.setClientAddress(clientAddress);
                    tgsContext.setRequest(request);
                    session.setAttribute((Object)CONTEXT_KEY, (Object)tgsContext);
                    TicketGrantingService.execute(tgsContext);
                    session.write((Object)tgsContext.getReply());
                    break;
                }
                case AS_REP: 
                case TGS_REP: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION);
                }
                default: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
                }
            }
        }
        catch (KerberosException ke) {
            String messageText = ke.getLocalizedMessage() + " (" + ke.getErrorCode() + ")";
            if (log.isDebugEnabled()) {
                log.warn(messageText, (Throwable)ke);
            } else {
                log.warn(messageText);
            }
            KrbError error = this.getErrorMessage(this.config.getServicePrincipal(), ke);
            if (log.isDebugEnabled()) {
                this.logErrorMessage(error);
            }
            session.write((Object)error);
        }
        catch (Exception e) {
            log.error(I18n.err((I18n)I18n.ERR_152, (Object[])new Object[]{e.getLocalizedMessage()}), (Throwable)e);
            session.write((Object)this.getErrorMessage(this.config.getServicePrincipal(), new KerberosException(ErrorType.KDC_ERR_SVC_UNAVAILABLE)));
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
        }
    }

    protected KrbError getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        KrbError krbError = new KrbError();
        KerberosTime now = new KerberosTime();
        krbError.setErrorCode(ErrorType.getTypeByValue((int)exception.getErrorCode()));
        krbError.setEText(exception.getLocalizedMessage());
        krbError.setSName(new PrincipalName(principal));
        krbError.setRealm(principal.getRealm());
        krbError.setSTime(now);
        krbError.setSusec(0);
        krbError.setEData(exception.getExplanatoryData());
        return krbError;
    }

    protected void logErrorMessage(KrbError error) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("Responding to request with error:");
            sb.append("\n\texplanatory text:      " + error.getEText());
            sb.append("\n\terror code:            " + error.getErrorCode());
            sb.append("\n\tclientPrincipal:       " + error.getCName()).append("@").append(error.getCRealm());
            sb.append("\n\tclient time:           " + error.getCTime());
            sb.append("\n\tserverPrincipal:       " + error.getSName()).append("@").append(error.getRealm());
            sb.append("\n\tserver time:           " + error.getSTime());
            log.debug(sb.toString());
        }
        catch (Exception e) {
            log.error(I18n.err((I18n)I18n.ERR_155, (Object[])new Object[0]), (Throwable)e);
        }
    }
}

