/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.protocol.shared.kerberos.GetPrincipal;
import org.apache.directory.server.protocol.shared.kerberos.StoreUtils;

public class DirectoryPrincipalStore
implements PrincipalStore {
    private final DirectoryService directoryService;
    private final Dn searchBaseDn;
    private CoreSession adminSession;

    public DirectoryPrincipalStore(DirectoryService directoryService, Dn searchBaseDn) {
        this.directoryService = directoryService;
        this.adminSession = directoryService.getAdminSession();
        this.searchBaseDn = searchBaseDn;
    }

    public void changePassword(KerberosPrincipal byPrincipal, KerberosPrincipal forPrincipal, String newPassword, boolean isInitialTicket) throws ChangePasswordException {
        try {
            Entry ebyPrincipalEntry = null;
            ebyPrincipalEntry = StoreUtils.findPrincipalEntry((CoreSession)this.adminSession, (Dn)this.searchBaseDn, (String)byPrincipal.getName());
            if (ebyPrincipalEntry == null) {
                throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_HARDERROR, ("No such principal " + byPrincipal).getBytes());
            }
            SchemaManager schemaManager = this.directoryService.getSchemaManager();
            CoreSession bySession = null;
            boolean isAdmin = ebyPrincipalEntry.getDn().getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            if (!isInitialTicket && !isAdmin) {
                throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_INITIAL_FLAG_NEEDED);
            }
            if (isAdmin) {
                bySession = this.adminSession;
            } else {
                LdapPrincipal byLdapPrincipal = new LdapPrincipal(schemaManager, ebyPrincipalEntry.getDn(), AuthenticationLevel.SIMPLE);
                bySession = new DefaultCoreSession(byLdapPrincipal, this.directoryService);
            }
            DefaultAttribute newPasswordAttribute = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("userPassword"), (byte[][])new byte[][]{Strings.getBytesUtf8((String)newPassword)});
            DefaultModification passwordMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)newPasswordAttribute);
            DefaultAttribute principalAttribute = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName"), new String[]{forPrincipal.getName()});
            DefaultModification principalMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)principalAttribute);
            Entry forPrincipalEntry = StoreUtils.findPrincipalEntry((CoreSession)bySession, (Dn)this.searchBaseDn, (String)forPrincipal.getName());
            this.adminSession.modify(forPrincipalEntry.getDn(), new Modification[]{passwordMod, principalMod});
        }
        catch (LdapException e) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_ACCESSDENIED, (Throwable)e);
        }
        catch (Exception e) {
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_HARDERROR, (Throwable)e);
        }
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)new GetPrincipal(principal).execute(this.adminSession, this.searchBaseDn);
    }
}

