/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.changepwd.protocol;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.changepwd.ChangePasswordServer;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.directory.server.kerberos.changepwd.messages.AbstractPasswordMessage;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordError;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordRequest;
import org.apache.directory.server.kerberos.changepwd.protocol.ChangePasswordProtocolCodecFactory;
import org.apache.directory.server.kerberos.changepwd.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.changepwd.service.ChangePasswordService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordProtocolHandler
implements IoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordProtocolHandler.class);
    private ChangePasswordServer server;
    private PrincipalStore store;
    private String contextKey = "context";

    public ChangePasswordProtocolHandler(ChangePasswordServer config, PrincipalStore store) {
        this.server = config;
        this.store = store;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)ChangePasswordProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        LOG.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        LOG.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        LOG.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        LOG.debug(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        LOG.debug("{} RCVD:  {}", (Object)session.getRemoteAddress(), message);
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        ChangePasswordRequest request = (ChangePasswordRequest)message;
        try {
            ChangePasswordContext changepwContext = new ChangePasswordContext();
            changepwContext.setConfig(this.server.getConfig());
            changepwContext.setStore(this.store);
            changepwContext.setClientAddress(clientAddress);
            changepwContext.setRequest((AbstractPasswordMessage)request);
            changepwContext.setReplayCache(this.server.getReplayCache());
            session.setAttribute((Object)this.getContextKey(), (Object)changepwContext);
            ChangePasswordService.execute(session, changepwContext);
            session.write((Object)changepwContext.getReply());
        }
        catch (KerberosException ke) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(ke.getLocalizedMessage(), (Throwable)ke);
            } else {
                LOG.warn(ke.getLocalizedMessage());
            }
            KrbError errorMessage = this.getErrorMessage(this.server.getConfig().getServicePrincipal(), ke);
            session.write((Object)new ChangePasswordError(request.getVersionNumber(), errorMessage));
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_152, (Object[])new Object[]{e.getLocalizedMessage()}), (Throwable)e);
            KrbError error = this.getErrorMessage(this.server.getConfig().getServicePrincipal(), (KerberosException)new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_UNKNOWN_ERROR));
            session.write((Object)new ChangePasswordError(request.getVersionNumber(), error));
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
        }
    }

    protected String getContextKey() {
        return this.contextKey;
    }

    private KrbError getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        KrbError krbError = new KrbError();
        KerberosTime now = new KerberosTime();
        krbError.setErrorCode(ErrorType.KRB_ERR_GENERIC);
        krbError.setEText(exception.getLocalizedMessage());
        krbError.setSName(new PrincipalName(principal));
        krbError.setSTime(now);
        krbError.setSusec(0);
        krbError.setRealm(principal.getRealm());
        krbError.setEData(this.buildExplanatoryData(exception));
        return krbError;
    }

    private byte[] buildExplanatoryData(KerberosException exception) {
        short resultCode = (short)exception.getErrorCode();
        byte[] resultString = new byte[]{0};
        if (exception.getExplanatoryData() == null || exception.getExplanatoryData().length == 0) {
            try {
                resultString = exception.getLocalizedMessage().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error(uee.getLocalizedMessage());
            }
        } else {
            resultString = exception.getExplanatoryData();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + resultString.length);
        byteBuffer.putShort(resultCode);
        byteBuffer.put(resultString);
        return byteBuffer.array();
    }

    public void inputClosed(IoSession session) {
    }
}

