/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)ModifyHandler.class);
    private static final ModificationItem[] EMPTY = new ModificationItem[0];
    private static Control[] EMPTY_CONTROLS = new Control[0];

    public void messageReceived(IoSession session, Object request) {
        ModifyRequest req = (ModifyRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", "ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", "throw");
            }
            ctx.setRequestControls((javax.naming.ldap.Control[])req.getControls().values().toArray(EMPTY_CONTROLS));
            ModificationItem[] mods = req.getModificationItems().toArray(EMPTY);
            ctx.modifyAttributes(req.getName(), mods);
        }
        catch (ReferralException e) {
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle modify request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            return;
        }
        catch (NamingException e) {
            String msg = "failed to modify entry " + req.getName();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn(e.getResolvedName().toString());
            }
            session.write((Object)req.getResultResponse());
            return;
        }
        result.setResultCode(ResultCodeEnum.SUCCESS);
        session.write((Object)req.getResultResponse());
    }
}

