/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Set;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainGuard
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(ChainGuard.class);

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        BindRequest bindRequest = (BindRequest)message;
        Set supportedMechanisms = (Set)session.getAttribute("supportedMechanisms");
        if (!supportedMechanisms.contains(bindRequest.getSaslMechanism())) {
            log.error("Bind error : {} mechanism not supported. Please check the server.xml configuration file (supportedMechanisms field)", (Object)bindRequest.getSaslMechanism());
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
            bindResult.setErrorMessage(bindRequest.getSaslMechanism() + " is not a supported mechanism.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        session.setAttribute("sessionMechanism", (Object)bindRequest.getSaslMechanism());
        next.execute(session, message);
    }
}

