/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.support.bind.GssapiCallbackHandler;
import org.apache.directory.server.ldap.support.bind.MechanismHandler;
import org.apache.mina.common.IoSession;

public class GssapiMechanismHandler
implements MechanismHandler {
    public SaslServer handleMechanism(IoSession session, Object message) throws Exception {
        SaslServer ss;
        if (session.containsAttribute("saslContext")) {
            ss = (SaslServer)session.getAttribute("saslContext");
        } else {
            Subject subject = (Subject)session.getAttribute("saslSubject");
            final Map saslProps = (Map)session.getAttribute("saslProps");
            final String saslHost = (String)session.getAttribute("saslHost");
            final GssapiCallbackHandler callbackHandler = new GssapiCallbackHandler(session, message);
            ss = (SaslServer)Subject.doAs(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Sasl.createSaslServer("GSSAPI", "ldap", saslHost, saslProps, callbackHandler);
                }
            });
            session.setAttribute("saslContext", (Object)ss);
        }
        return ss;
    }
}

