/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.ReferralAwareRequestHandler;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddHandler
extends ReferralAwareRequestHandler<AddRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AddHandler.class);

    @Override
    public void handleIgnoringReferrals(LdapSession session, LdapDN reqTargetDn, ClonedServerEntry entry, AddRequest req) {
        LOG.debug("Handling add request while ignoring referrals: {}", (Object)req);
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            session.getCoreSession().add(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

