
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;



public class AutofsObjectClassProducer extends AbstractBootstrapProducer
{

    public AutofsObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.2312.4.2.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.2312.4.2.3", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "An entry in an automounter map" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "automountInformation" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "automount" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.2312.4.2.3", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.2312.4.2.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.2312.4.2.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "An group of related automount objects" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "ou" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "automountMap" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.2312.4.2.2", objectClass );

    }
}
