
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.shared.ldap.schema.*;
import org.apache.directory.server.schema.registries.*;



public class CorbaAttributeTypeProducer extends AbstractBootstrapProducer
{

    public CorbaAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;

        
                        
        attributeType = newAttributeType( "1.3.6.1.4.1.42.2.27.4.1.14", registries );
        attributeType.setDescription( "Stringified interoperable object reference of a CORBA object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );
        names.clear();
        names.add( "corbaIor" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.1.14", attributeType );

 
                        
        attributeType = newAttributeType( "1.3.6.1.4.1.42.2.27.4.1.15", registries );
        attributeType.setDescription( "Repository ids of interfaces implemented by a CORBA object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "corbaRepositoryId" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.1.15", attributeType );

    }
}
