
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;



public class CorbaObjectClassProducer extends AbstractBootstrapProducer
{

    public CorbaObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.10 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.10", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Container for a CORBA object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "corbaContainer" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.10", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.9", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "CORBA object representation" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "corbaRepositoryId" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "corbaObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.9", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.11 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.11", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "CORBA interoperable object reference" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "corbaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "corbaIor" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "corbaObjectReference" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.11", objectClass );

    }
}
