
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.shared.ldap.schema.*;
import org.apache.directory.server.schema.registries.*;



public class InetorgpersonAttributeTypeProducer extends AbstractBootstrapProducer
{

    public InetorgpersonAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;

        
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.1", registries );
        attributeType.setDescription( "RFC2798: vehicle license or registration plate" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "carLicense" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.1", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.2", registries );
        attributeType.setDescription( "RFC2798: identifies a department within an organization" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "departmentNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.2", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.241", registries );
        attributeType.setDescription( "RFC2798: preferred name to be used when displaying entries" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "displayName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.241", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.3", registries );
        attributeType.setDescription( "RFC2798: numerically identifies an employee within an organization" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "employeeNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.3", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.4", registries );
        attributeType.setDescription( "RFC2798: type of employment for a person" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "employeeType" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.4", attributeType );

 
                        
        attributeType = newAttributeType( "0.9.2342.19200300.100.1.60", registries );
        attributeType.setDescription( "RFC2798: a JPEG image" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.28" );
        names.clear();
        names.add( "jpegPhoto" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.60", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.39", registries );
        attributeType.setDescription( "RFC2798: preferred written or spoken language for a person" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );
        names.clear();
        names.add( "preferredLanguage" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.39", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.40", registries );
        attributeType.setDescription( "RFC2798: PKCS#7 SignedData used to support S/MIME" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.5" );
        names.clear();
        names.add( "userSMIMECertificate" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.40", attributeType );

 
                        
        attributeType = newAttributeType( "2.16.840.1.113730.3.1.216", registries );
        attributeType.setDescription( "RFC2798: personal identity information, a PKCS #12 PFX" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.5" );
        names.clear();
        names.add( "userPKCS12" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.216", attributeType );

    }
}
