
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;



public class InetorgpersonObjectClassProducer extends AbstractBootstrapProducer
{

    public InetorgpersonObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113730.3.2.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113730.3.2.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2798: Internet Organizational Person" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "organizationalPerson" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "audio" );
        array.add( "businessCategory" );
        array.add( "carLicense" );
        array.add( "departmentNumber" );
        array.add( "displayName" );
        array.add( "employeeNumber" );
        array.add( "employeeType" );
        array.add( "givenName" );
        array.add( "homePhone" );
        array.add( "homePostalAddress" );
        array.add( "initials" );
        array.add( "jpegPhoto" );
        array.add( "labeledURI" );
        array.add( "mail" );
        array.add( "manager" );
        array.add( "mobile" );
        array.add( "o" );
        array.add( "pager" );
        array.add( "photo" );
        array.add( "roomNumber" );
        array.add( "secretary" );
        array.add( "uid" );
        array.add( "userCertificate" );
        array.add( "x500uniqueIdentifier" );
        array.add( "preferredLanguage" );
        array.add( "userSMIMECertificate" );
        array.add( "userPKCS12" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "inetOrgPerson" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.2.2", objectClass );

    }
}
