
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;



public class JavaObjectClassProducer extends AbstractBootstrapProducer
{

    public JavaObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Container for a Java object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaContainer" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.4", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java object representation" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "javaClassName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "javaClassNames" );
        array.add( "javaCodebase" );
        array.add( "javaDoc" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.4", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.5", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java serialized object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "javaSerializedData" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaSerializedObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.5", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.8", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java marshalled object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "javaSerializedData" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaMarshalledObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.8", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.7", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "JNDI reference" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "javaReferenceAddress" );
        array.add( "javaFactory" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaNamingReference" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.7", objectClass );

    }
}
