
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;



public class MozillaObjectClassProducer extends AbstractBootstrapProducer
{

    public MozillaObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


            

    
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.13769.2.2.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.13769.2.2.1", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "inetOrgPerson" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "mozillaNickname" );
        array.add( "mozillaUseHtmlMail" );
        array.add( "mozillaSecondEmail" );
        array.add( "mozillaPostalAddress2" );
        array.add( "mozillaHomePostalAddress2" );
        array.add( "mozillaHomeLocalityName" );
        array.add( "mozillaHomeState" );
        array.add( "mozillaHomePostalCode" );
        array.add( "mozillaHomeCountryName" );
        array.add( "mozillaHomeFriendlyCountryName" );
        array.add( "mozillaHomeUrl" );
        array.add( "mozillaWorkUrl" );
        array.add( "mozillaCustom1" );
        array.add( "mozillaCustom2" );
        array.add( "mozillaCustom3" );
        array.add( "mozillaCustom4" );
        array.add( "nsAIMid" );
        array.add( "c" );
        array.add( "co" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "mozillaAbPersonObsolete" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.13769.2.2.1", objectClass );

    }
}
