
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the cosine schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class CosineAttributeTypeProducer extends AbstractBootstrapProducer
{

    public CosineAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.2", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "textEncodedORAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.4", registries );
        attributeType.setDescription( "RFC1274: general information" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 2048 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "info" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.5", registries );
        attributeType.setDescription( "RFC1274: favorite drink" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "drink" );
        names.add( "favouriteDrink" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.6", registries );
        attributeType.setDescription( "RFC1274: room number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "roomNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.7", registries );
        attributeType.setDescription( "RFC1274: photo (G3 fax)" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 25000 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.23" );

        names.clear();
        names.add( "photo" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.8", registries );
        attributeType.setDescription( "RFC1274: categorory of user" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "userClass" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.9", registries );
        attributeType.setDescription( "RFC1274: host computer" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "host" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.10", registries );
        attributeType.setDescription( "RFC1274: DN of manager" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "manager" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.11", registries );
        attributeType.setDescription( "RFC1274: unique identifier of document" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "documentIdentifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.12", registries );
        attributeType.setDescription( "RFC1274: title of document" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "documentTitle" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.13", registries );
        attributeType.setDescription( "RFC1274: version of document" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "documentVersion" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.14", registries );
        attributeType.setDescription( "RFC1274: DN of author of document" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "documentAuthor" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.15", registries );
        attributeType.setDescription( "RFC1274: location of document original" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "documentLocation" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.15", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.20 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.20", registries );
        attributeType.setDescription( "RFC1274: home telephone number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "telephoneNumberMatch" );
        attributeType.setSubstrId( "telephoneNumberSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.50" );

        names.clear();
        names.add( "homePhone" );
        names.add( "homeTelephoneNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.20", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.21 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.21", registries );
        attributeType.setDescription( "RFC1274: DN of secretary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "secretary" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.21", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.22 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.22", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.39" );

        names.clear();
        names.add( "otherMailbox" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.22", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.26 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.26", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "aRecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.26", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.27 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.27", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "mDRecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.27", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.28 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.28", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "mXRecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.28", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.29 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.29", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "nSRecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.29", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.30 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.30", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sOARecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.30", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.31 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.31", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "cNAMERecord" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.31", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.38 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.38", registries );
        attributeType.setDescription( "RFC1274: DN of entry associated with domain" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "associatedName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.38", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.39 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.39", registries );
        attributeType.setDescription( "RFC1274: home postal address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreListMatch" );
        attributeType.setSubstrId( "caseIgnoreListSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.41" );

        names.clear();
        names.add( "homePostalAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.39", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.40 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.40", registries );
        attributeType.setDescription( "RFC1274: personal title" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "personalTitle" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.40", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.41 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.41", registries );
        attributeType.setDescription( "RFC1274: mobile telephone number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "telephoneNumberMatch" );
        attributeType.setSubstrId( "telephoneNumberSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.50" );

        names.clear();
        names.add( "mobile" );
        names.add( "mobileTelephoneNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.41", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.42 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.42", registries );
        attributeType.setDescription( "RFC1274: pager telephone number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "telephoneNumberMatch" );
        attributeType.setSubstrId( "telephoneNumberSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.50" );

        names.clear();
        names.add( "pager" );
        names.add( "pagerTelephoneNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.42", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.43 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.43", registries );
        attributeType.setDescription( "RFC1274: friendly country name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "co" );
        names.add( "friendlyCountryName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.43", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.44 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.44", registries );
        attributeType.setDescription( "RFC1274: unique identifer" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "uniqueIdentifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.44", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.45 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.45", registries );
        attributeType.setDescription( "RFC1274: organizational status" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "organizationalStatus" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.45", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.46 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.46", registries );
        attributeType.setDescription( "RFC1274: Janet mailbox" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "janetMailbox" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.46", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.47 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.47", registries );
        attributeType.setDescription( "RFC1274: mail preference option" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "mailPreferenceOption" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.47", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.48 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.48", registries );
        attributeType.setDescription( "RFC1274: name of building" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "buildingName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.48", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.49 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.49", registries );
        attributeType.setDescription( "RFC1274: DSA Quality" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.19" );

        names.clear();
        names.add( "dSAQuality" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.49", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.50 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.50", registries );
        attributeType.setDescription( "RFC1274: Single Level Quality" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.13" );

        names.clear();
        names.add( "singleLevelQuality" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.50", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.51 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.51", registries );
        attributeType.setDescription( "RFC1274: Subtree Mininum Quality" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.13" );

        names.clear();
        names.add( "subtreeMinimumQuality" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.51", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.52 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.52", registries );
        attributeType.setDescription( "RFC1274: Subtree Maximun Quality" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.13" );

        names.clear();
        names.add( "subtreeMaximumQuality" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.52", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.53 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.53", registries );
        attributeType.setDescription( "RFC1274: Personal Signature (G3 fax)" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.23" );

        names.clear();
        names.add( "personalSignature" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.53", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.54 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.54", registries );
        attributeType.setDescription( "RFC1274: DIT Redirect" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "dITRedirect" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.54", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.55 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.55", registries );
        attributeType.setDescription( "RFC1274: audio (u-law)" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 25000 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.4" );

        names.clear();
        names.add( "audio" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.55", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.56 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.56", registries );
        attributeType.setDescription( "RFC1274: publisher of document" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "documentPublisher" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.56", attributeType );
    }
}
