
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.Registries;


/**
 * A producer of schema objectClass definations for the dhcp schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class DhcpObjectClassProducer extends AbstractBootstrapProducer
{

    public DhcpObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Service object that represents the actual DHCP Service configuration. This is a container object." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "dhcpPrimaryDN" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpSecondaryDN" );
        array.add( "dhcpSharedNetworkDN" );
        array.add( "dhcpSubnetDN" );
        array.add( "dhcpGroupDN" );
        array.add( "dhcpHostDN" );
        array.add( "dhcpClassesDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpService" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.1", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This stores configuration information for a shared network." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpSubnetDN" );
        array.add( "dhcpPoolDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpSharedNetwork" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.2", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.3", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This class defines a subnet. This is a container object." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "dhcpNetMask" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpRange" );
        array.add( "dhcpPoolDN" );
        array.add( "dhcpGroupDN" );
        array.add( "dhcpHostDN" );
        array.add( "dhcpClassesDN" );
        array.add( "dhcpLeasesDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpSubnet" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.3", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.4", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This stores configuration information about a pool." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "dhcpRange" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpClassesDN" );
        array.add( "dhcpPermitList" );
        array.add( "dhcpLeasesDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpPool" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.4", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.5", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Group object that lists host DNs and parameters. This is a container object." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpHostDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpGroup" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.5", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.6", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This represents information about a particular client" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpLeaseDN" );
        array.add( "dhcpHWAddress" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpHost" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.6", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.7", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Represents information about a collection of related clients." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpSubClassesDN" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpClass" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.7", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.8", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Represents information about a collection of related classes." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpClassData" );
        array.add( "dhcpOptionsDN" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpSubClass" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.8", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.9", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Represents information about a collection of options defined." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpOption" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpOptions" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.9", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.10 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.10", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This class represents an IP Address, which may or may not have been leased." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "dhcpAddressState" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpExpirationTime" );
        array.add( "dhcpStartTimeOfState" );
        array.add( "dhcpLastTransactionTime" );
        array.add( "dhcpBootpFlag" );
        array.add( "dhcpDomainName" );
        array.add( "dhcpDnsStatus" );
        array.add( "dhcpRequestedHostName" );
        array.add( "dhcpAssignedHostName" );
        array.add( "dhcpReservedForClient" );
        array.add( "dhcpAssignedToClient" );
        array.add( "dhcpRelayAgentInfo" );
        array.add( "dhcpHWAddress" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpLeases" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.10", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.11 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.11", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "This is the object that holds past information about the IP address. The cn is the time/date stamp when the address was assigned or released, the address state at the time, if the address was assigned or released." );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpAddressState" );
        array.add( "dhcpExpirationTime" );
        array.add( "dhcpStartTimeOfState" );
        array.add( "dhcpLastTransactionTime" );
        array.add( "dhcpBootpFlag" );
        array.add( "dhcpDomainName" );
        array.add( "dhcpDnsStatus" );
        array.add( "dhcpRequestedHostName" );
        array.add( "dhcpAssignedHostName" );
        array.add( "dhcpReservedForClient" );
        array.add( "dhcpAssignedToClient" );
        array.add( "dhcpRelayAgentInfo" );
        array.add( "dhcpHWAddress" );
        array.add( "dhcpErrorLog" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpLog" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.11", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113719.1.203.6.12 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113719.1.203.6.12", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "DHCP Server Object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "dhcpServiceDN" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dhcpVersion" );
        array.add( "dhcpImplementation" );
        array.add( "dhcpHashBucketAssignment" );
        array.add( "dhcpDelayedServiceParameter" );
        array.add( "dhcpMaxClientLeadTime" );
        array.add( "dhcpFailOverEndpointState" );
        array.add( "dhcpStatements" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dhcpServer" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113719.1.203.6.12", objectClass );
    }
}
